/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.converter;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import me.ahoo.cosid.IdConverter;

public final class Radix62IdConverter
implements IdConverter {
    public static final int MAX_CHAR_SIZE = 11;
    public static final int RADIX = 62;
    public static final Radix62IdConverter INSTANCE = new Radix62IdConverter(false, 11);
    public static final Radix62IdConverter PAD_START = new Radix62IdConverter(true, 11);
    private static final char ZERO = '0';
    private static final char NINE = '9';
    private static final char UPPERCASE_A = 'A';
    private static final int UPPERCASE_OFFSET = 10;
    private static final char UPPERCASE_Z = 'Z';
    private static final char LOWERCASE_A = 'a';
    private static final int LOWERCASE_OFFSET = 36;
    private static final char LOWERCASE_Z = 'z';
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char PAD_CHAR = '0';
    private final boolean padStart;
    private final int charSize;
    private final long maxId;

    public static Radix62IdConverter of(boolean padStart, int charSize) {
        if (Radix62IdConverter.INSTANCE.padStart == padStart && Radix62IdConverter.INSTANCE.charSize == charSize) {
            return INSTANCE;
        }
        if (Radix62IdConverter.PAD_START.padStart == padStart && Radix62IdConverter.PAD_START.charSize == charSize) {
            return PAD_START;
        }
        return new Radix62IdConverter(padStart, charSize);
    }

    public Radix62IdConverter(boolean padStart, int charSize) {
        Preconditions.checkArgument((charSize > 0 && charSize <= 11 ? 1 : 0) != 0, (String)"charSize cannot be greater than MAX_CHAR_SIZE[%s]!", (int)11);
        this.padStart = padStart;
        this.charSize = charSize;
        this.maxId = 11 == charSize ? Long.MAX_VALUE : Double.valueOf(Math.pow(62.0, charSize)).longValue();
    }

    @Override
    public String asString(long id) {
        Preconditions.checkArgument((id > 0L ? 1 : 0) != 0, (String)"id[%s] must be greater than 0!", (long)id);
        if (this.charSize < 11) {
            Preconditions.checkArgument((id < this.maxId ? 1 : 0) != 0, (String)"id[%s] cannot be greater than maxId:[%s]!", (long)id, (long)this.maxId);
        }
        char[] buf = new char[this.charSize];
        int charIdx = this.charSize;
        while (id > 0L) {
            int mod = (int)(id % 62L);
            buf[--charIdx] = digits[mod];
            id /= 62L;
        }
        if (this.padStart && charIdx > 0) {
            while (charIdx > 0) {
                buf[--charIdx] = 48;
            }
        }
        return new String(buf, charIdx, this.charSize - charIdx);
    }

    static int offset(char digitChar) {
        if (digitChar >= '0' && digitChar <= '9') {
            return digitChar - 48;
        }
        if (digitChar >= 'A' && digitChar <= 'Z') {
            return digitChar - 65 + 10;
        }
        if (digitChar >= 'a' && digitChar <= 'z') {
            return digitChar - 97 + 36;
        }
        return -1;
    }

    @Override
    public long asLong(String idString) {
        char firstChar = idString.charAt(0);
        if (firstChar < '0') {
            throw new NumberFormatException(Strings.lenientFormat((String)"For input string: [%s]!", (Object[])new Object[]{idString}));
        }
        long result = 0L;
        int charIdx = 0;
        int charLen = idString.length();
        if (charLen > this.charSize) {
            throw new NumberFormatException(Strings.lenientFormat((String)"For input string:[%s]. charLen cannot be greater than charSize:[%s]!", (Object[])new Object[]{idString, this.charSize}));
        }
        while (charIdx < charLen) {
            char digitChar;
            int digit;
            if ((digit = Radix62IdConverter.offset(digitChar = idString.charAt(charIdx++))) < 0) {
                throw new NumberFormatException(Strings.lenientFormat((String)"For input string:[%s]. digitChar:[%s]@[%s] !", (Object[])new Object[]{idString, Character.valueOf(digitChar), charIdx}));
            }
            result *= 62L;
            result += (long)digit;
        }
        return result;
    }
}

