/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.annotation;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import me.ahoo.cosid.accessor.IdDefinition;
import me.ahoo.cosid.accessor.parser.FieldDefinitionParser;
import me.ahoo.cosid.annotation.CosId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationDefinitionParser
implements FieldDefinitionParser {
    private static final Logger log = LoggerFactory.getLogger(AnnotationDefinitionParser.class);
    public static final AnnotationDefinitionParser INSTANCE = new AnnotationDefinitionParser();

    @Override
    public IdDefinition parse(List<Class<?>> lookupClassList, Field field) {
        Optional<CosId> clazzCosIdOp = lookupClassList.stream().filter(clazz -> clazz.isAnnotationPresent(CosId.class)).map(clazz -> clazz.getAnnotation(CosId.class)).findFirst();
        if (clazzCosIdOp.isPresent()) {
            CosId clazzCosId = clazzCosIdOp.get();
            if (!field.getName().equals(clazzCosId.field())) {
                return IdDefinition.NOT_FOUND;
            }
            return new IdDefinition(clazzCosId.value(), field);
        }
        CosId fieldCosId = field.getAnnotation(CosId.class);
        if (null == fieldCosId) {
            return IdDefinition.NOT_FOUND;
        }
        return new IdDefinition(fieldCosId.value(), field);
    }
}

