/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.accessor.scanner;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.util.Arrays;
import me.ahoo.cosid.CosIdException;
import me.ahoo.cosid.accessor.CosIdAccessor;
import me.ahoo.cosid.accessor.parser.CosIdAccessorParser;
import me.ahoo.cosid.accessor.parser.DefaultAccessorParser;
import me.ahoo.cosid.accessor.parser.FieldDefinitionParser;
import me.ahoo.cosid.accessor.registry.CosIdAccessorRegistry;
import me.ahoo.cosid.accessor.scanner.CosIdScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCosIdScanner
implements CosIdScanner {
    private static final Logger log = LoggerFactory.getLogger(DefaultCosIdScanner.class);
    private final String[] basePackages;
    private final CosIdAccessorParser cosIdAccessorParser;
    private final CosIdAccessorRegistry cosIdAccessorRegistry;

    public DefaultCosIdScanner(String[] basePackages, FieldDefinitionParser fieldDefinitionParser, CosIdAccessorRegistry cosIdAccessorRegistry) {
        this(basePackages, new DefaultAccessorParser(fieldDefinitionParser), cosIdAccessorRegistry);
    }

    public DefaultCosIdScanner(String[] basePackages, CosIdAccessorParser cosIdAccessorParser, CosIdAccessorRegistry cosIdAccessorRegistry) {
        this.basePackages = basePackages;
        this.cosIdAccessorRegistry = cosIdAccessorRegistry;
        this.cosIdAccessorParser = cosIdAccessorParser;
    }

    @Override
    public void scan() {
        if (log.isInfoEnabled()) {
            log.info("scan - basePackages:{}.", (Object)Arrays.toString(this.basePackages));
        }
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            ClassPath classPath = ClassPath.from((ClassLoader)classLoader);
            for (String basePackage : this.basePackages) {
                ImmutableSet classInfos = classPath.getTopLevelClassesRecursive(basePackage);
                for (ClassPath.ClassInfo classInfo : classInfos) {
                    Class<?> clazz = classLoader.loadClass(classInfo.getName());
                    if (clazz.isInterface()) continue;
                    CosIdAccessor cosIdAccessor = this.cosIdAccessorParser.parse(clazz);
                    this.cosIdAccessorRegistry.register(clazz, cosIdAccessor);
                }
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new CosIdException(e.getMessage(), e);
        }
    }
}

