/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.accessor.parser;

import com.google.common.base.Strings;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import me.ahoo.cosid.accessor.CosIdAccessor;
import me.ahoo.cosid.accessor.CosIdGetter;
import me.ahoo.cosid.accessor.CosIdSetter;
import me.ahoo.cosid.accessor.DefaultCosIdAccessor;
import me.ahoo.cosid.accessor.IdDefinition;
import me.ahoo.cosid.accessor.IdTypeNotSupportException;
import me.ahoo.cosid.accessor.MultipleIdNotSupportException;
import me.ahoo.cosid.accessor.field.FieldGetter;
import me.ahoo.cosid.accessor.field.FieldSetter;
import me.ahoo.cosid.accessor.method.MethodGetter;
import me.ahoo.cosid.accessor.method.MethodSetter;
import me.ahoo.cosid.accessor.parser.CosIdAccessorParser;
import me.ahoo.cosid.accessor.parser.FieldDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAccessorParser
implements CosIdAccessorParser {
    private static final Logger log = LoggerFactory.getLogger(DefaultAccessorParser.class);
    public static final String GET_PREFIX = "get";
    public static final String SET_PREFIX = "set";
    private final ConcurrentHashMap<Class<?>, CosIdAccessor> classMapAccessor = new ConcurrentHashMap();
    private final FieldDefinitionParser definitionParser;

    public DefaultAccessorParser(FieldDefinitionParser definitionParser) {
        this.definitionParser = definitionParser;
    }

    @Override
    public CosIdAccessor parse(Class<?> clazz) {
        return this.classMapAccessor.computeIfAbsent(clazz, key -> this.parseClass(clazz));
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    public static Method parseGetter(Field field) {
        String getterName = GET_PREFIX + DefaultAccessorParser.capitalize(field.getName());
        try {
            Method method = field.getDeclaringClass().getMethod(getterName, new Class[0]);
            if (!method.getReturnType().equals(field.getType())) {
                return null;
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method parseSetter(Field field) {
        String setterName = SET_PREFIX + DefaultAccessorParser.capitalize(field.getName());
        try {
            Method method = field.getDeclaringClass().getMethod(setterName, field.getType());
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    protected CosIdAccessor parseClass(Class<?> clazz) {
        CosIdAccessor firstAccessor = CosIdAccessor.NOT_FOUND;
        Class<?> currentDeclaringClass = clazz;
        ArrayList lookupClassList = new ArrayList();
        while (!Object.class.equals(currentDeclaringClass)) {
            lookupClassList.add(currentDeclaringClass);
            for (Field declaredField : currentDeclaringClass.getDeclaredFields()) {
                IdDefinition idDefinition = this.definitionParser.parse(lookupClassList, declaredField);
                if (idDefinition == null || IdDefinition.NOT_FOUND.equals(idDefinition)) continue;
                if (!CosIdAccessor.NOT_FOUND.equals(firstAccessor)) {
                    throw new MultipleIdNotSupportException(clazz);
                }
                IdDefinition fixedIdDefinition = this.fixGenericFieldActualType(lookupClassList, idDefinition);
                firstAccessor = this.definitionAsAccessor(fixedIdDefinition);
            }
            currentDeclaringClass = currentDeclaringClass.getSuperclass();
        }
        return firstAccessor;
    }

    private IdDefinition fixGenericFieldActualType(List<Class<?>> lookupClassList, IdDefinition idDefinition) {
        Type fieldGenericType = idDefinition.getIdField().getGenericType();
        if (!(fieldGenericType instanceof TypeVariable)) {
            return idDefinition;
        }
        for (int i = lookupClassList.size() - 2; i >= 0; --i) {
            Class<?> subClass;
            Class<?> superClass = lookupClassList.get(i + 1);
            if (!((fieldGenericType = this.getActualFieldType(fieldGenericType, superClass, subClass = lookupClassList.get(i))) instanceof Class)) continue;
            return new IdDefinition(idDefinition.getGeneratorName(), idDefinition.getIdField(), (Class)fieldGenericType);
        }
        return idDefinition;
    }

    private Type getActualFieldType(Type typeVariable, Class<?> superClass, Class<?> subClass) {
        int genericVarIdx = -1;
        TypeVariable<Class<?>>[] typeVariables = superClass.getTypeParameters();
        for (int i = 0; i < typeVariables.length; ++i) {
            if (!typeVariable.equals(typeVariables[i])) continue;
            genericVarIdx = i;
        }
        if (genericVarIdx == -1) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)"Type Parameter:[%s] not found in Class:[%].", (Object[])new Object[]{typeVariable, superClass}));
        }
        ParameterizedType genericSuperclass = (ParameterizedType)subClass.getGenericSuperclass();
        Type[] actualTypes = genericSuperclass.getActualTypeArguments();
        return actualTypes[genericVarIdx];
    }

    protected CosIdAccessor definitionAsAccessor(IdDefinition idDefinition) {
        Field idField = idDefinition.getIdField();
        if (!CosIdAccessor.availableType(idDefinition.getIdType())) {
            throw new IdTypeNotSupportException(idField);
        }
        if (Modifier.isFinal(idField.getModifiers()) && log.isWarnEnabled()) {
            log.warn("idField:[{}] is final.", (Object)idField);
        }
        Method getter = DefaultAccessorParser.parseGetter(idField);
        Method setter = DefaultAccessorParser.parseSetter(idField);
        CosIdGetter cosIdGetter = getter != null ? new MethodGetter(getter) : new FieldGetter(idField);
        CosIdSetter cosIdSetter = setter != null ? new MethodSetter(setter) : new FieldSetter(idField);
        return new DefaultCosIdAccessor(idDefinition, cosIdGetter, cosIdSetter);
    }
}

