/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.accessor;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import me.ahoo.cosid.IdGenerator;
import me.ahoo.cosid.accessor.CosIdGetter;
import me.ahoo.cosid.accessor.CosIdSetter;
import me.ahoo.cosid.accessor.EnsureId;
import me.ahoo.cosid.accessor.IdDefinition;
import me.ahoo.cosid.accessor.IdMetadata;

public interface CosIdAccessor
extends CosIdGetter,
CosIdSetter,
IdMetadata,
EnsureId {
    public static final NotFound NOT_FOUND = new NotFound();

    public static boolean availableType(Class<?> idType) {
        return String.class.equals(idType) || Long.class.equals(idType) || Long.TYPE.equals(idType) || Integer.class.equals(idType) || Integer.TYPE.equals(idType);
    }

    public static void ensureAccessible(AccessibleObject accessibleObject) {
        if (!accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
    }

    public static class NotFound
    implements CosIdAccessor {
        @Override
        public IdDefinition getIdDefinition() {
            return null;
        }

        @Override
        public IdGenerator getIdGenerator() {
            return null;
        }

        @Override
        public Field getIdField() {
            return null;
        }

        @Override
        public Object getId(Object target) {
            return null;
        }

        @Override
        public void setId(Object target, Object id) {
        }

        @Override
        public boolean ensureId(Object target) {
            return false;
        }
    }
}

