/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk8.core.IBuffer;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IModularClassFile;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IModuleDescription;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IType;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaCore;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.WorkingCopyOwner;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.classfmt.ClassFileReader;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.classfmt.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IBinaryModule;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.AbstractClassFile;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.BinaryModule;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.BufferManager;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.ClassFileInfo;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JarPackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JrtPackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.NamedMember;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.OpenableElementInfo;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.PackageFragment;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.PackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.PackageFragmentRootInfo;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.SourceMapper;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.model.BinaryModuleDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.model.BinaryModuleFactory;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.MementoTokenizer;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.Util;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class ModularClassFile
extends AbstractClassFile
implements IModularClassFile {
    protected ModularClassFile(PackageFragment parent) {
        super(parent, "module-info");
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        IBinaryModule moduleInfo = this.getBinaryModuleInfo();
        if (moduleInfo == null) {
            info.setChildren(JavaElement.NO_ELEMENTS);
            return false;
        }
        BinaryModule module = new BinaryModule((JavaElement)this, moduleInfo);
        newElements.put(module, moduleInfo);
        info.setChildren(new IJavaElement[]{module});
        ((ClassFileInfo)info).setModule(module);
        ((PackageFragmentRootInfo)this.getPackageFragmentRoot().getElementInfo()).setModule(module);
        return true;
    }

    @Override
    public IType findPrimaryType() {
        return null;
    }

    public IBinaryModule getBinaryModuleInfo() throws JavaModelException {
        try {
            IBinaryModule info = this.getJarBinaryModuleInfo();
            if (info == null) {
                throw this.newNotPresentException();
            }
            return info;
        }
        catch (ClassFormatException cfe) {
            if (JavaCore.getPlugin().isDebugging()) {
                cfe.printStackTrace(System.err);
            }
            return null;
        }
        catch (IOException ioe) {
            throw new JavaModelException(ioe, 985);
        }
        catch (CoreException e) {
            if (e instanceof JavaModelException) {
                throw (JavaModelException)e;
            }
            throw new JavaModelException(e);
        }
    }

    private IBinaryModule getJarBinaryModuleInfo() throws CoreException, IOException, ClassFormatException {
        BinaryModuleDescriptor descriptor = BinaryModuleFactory.createDescriptor(this);
        if (descriptor == null) {
            return null;
        }
        IBinaryModule result = null;
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (this.getPackageFragmentRoot() instanceof JarPackageFragmentRoot) {
            if (root instanceof JrtPackageFragmentRoot || this.name.equals("module-info")) {
                String entryName;
                PackageFragment pkg = (PackageFragment)this.getParent();
                JarPackageFragmentRoot jarRoot = (JarPackageFragmentRoot)this.getPackageFragmentRoot();
                byte[] contents = this.getClassFileContent(jarRoot, entryName = jarRoot.getClassFilePath(Util.concatWith(pkg.names, this.getElementName(), '/')));
                if (contents != null) {
                    String fileName = String.valueOf(root.getHandleIdentifier()) + '|' + entryName;
                    ClassFileReader classFileReader = new ClassFileReader(contents, fileName.toCharArray(), false);
                    return classFileReader.getModuleDeclaration();
                }
            } else {
                result = BinaryModuleFactory.readModule(descriptor, null);
            }
        } else {
            result = BinaryModuleFactory.readModule(descriptor, null);
        }
        return result;
    }

    @Override
    public IJavaElement getElementAt(int position) throws JavaModelException {
        IJavaElement parentElement = this.getParent();
        while (parentElement.getElementType() != 3) {
            parentElement = parentElement.getParent();
        }
        PackageFragmentRoot root = (PackageFragmentRoot)parentElement;
        SourceMapper mapper = root.getSourceMapper();
        if (mapper == null) {
            return null;
        }
        this.getBuffer();
        IModuleDescription module = this.getModule();
        return this.findElement(module, position, mapper);
    }

    @Override
    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '`': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String modName = memento.nextToken();
                BinaryModule mod = new BinaryModule((JavaElement)this, modName);
                return mod.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '\'';
    }

    @Override
    protected void escapeMementoName(StringBuffer buffer, String mementoName) {
    }

    @Override
    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws JavaModelException {
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            return this.mapSource(mapper);
        }
        return null;
    }

    private IBuffer mapSource(SourceMapper mapper) throws JavaModelException {
        char[] contents = mapper.findSource(this.getModule());
        if (contents != null) {
            IBuffer buffer = BufferManager.createBuffer(this);
            if (buffer == null) {
                return null;
            }
            BufferManager bufManager = this.getBufferManager();
            bufManager.addBuffer(buffer);
            if (buffer.getCharacters() == null) {
                buffer.setContents(contents);
            }
            buffer.addBufferChangedListener(this);
            mapper.mapSource((NamedMember)((Object)this.getModule()), contents, null);
            return buffer;
        }
        IBuffer buffer = BufferManager.createNullBuffer(this);
        if (buffer == null) {
            return null;
        }
        BufferManager bufManager = this.getBufferManager();
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    @Override
    public IModuleDescription getModule() throws JavaModelException {
        BinaryModule module = (BinaryModule)((ClassFileInfo)this.getElementInfo()).getModule();
        if (module == null) {
            throw this.newNotPresentException();
        }
        return module;
    }
}

