/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaProject;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IPackageFragment;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IPackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk8.core.ITypeRoot;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.BinaryType;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.ClasspathAccessRule;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.ElementCache;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaElementInfo;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.LRUCache;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.Util;
import java.util.HashMap;
import java.util.Map;

public class JavaModelCache {
    public static boolean VERBOSE = false;
    public static boolean DEBUG_CACHE_INSERTIONS = false;
    public static final Object NON_EXISTING_JAR_TYPE_INFO = new Object();
    protected double memoryRatio;
    protected JavaElementInfo modelInfo;
    protected HashMap<IJavaProject, JavaElementInfo> projectCache;
    protected ElementCache<IPackageFragmentRoot> rootCache;
    protected ElementCache<IPackageFragment> pkgCache;
    protected ElementCache<ITypeRoot> openableCache;
    protected Map<IJavaElement, Object> childrenCache;
    protected LRUCache<ClasspathAccessRule, ClasspathAccessRule> accessRuleCache;
    protected LRUCache<IJavaElement, Object> jarTypeCache;

    private double getOpenableRatio() {
        return this.getRatioForProperty("io.spring.javaformat.eclipse.jdt.jdk8.core.javamodelcache.ratio");
    }

    private double getJarTypeRatio() {
        return this.getRatioForProperty("io.spring.javaformat.eclipse.jdt.jdk8.core.javamodelcache.jartyperatio");
    }

    private double getRatioForProperty(String propertyName) {
        String property = System.getProperty(propertyName);
        if (property != null) {
            try {
                return Double.parseDouble(property);
            }
            catch (NumberFormatException e) {
                Util.log(e, "Could not parse value for " + propertyName + ": " + property);
            }
        }
        return 1.0;
    }

    public Object getInfo(IJavaElement element) {
        switch (element.getElementType()) {
            case 1: {
                return this.modelInfo;
            }
            case 2: {
                return this.projectCache.get(element);
            }
            case 3: {
                return this.rootCache.get((IPackageFragmentRoot)element);
            }
            case 4: {
                return this.pkgCache.get((IPackageFragment)element);
            }
            case 5: 
            case 6: {
                return this.openableCache.get((ITypeRoot)element);
            }
            case 7: {
                Object result = this.jarTypeCache.get(element);
                if (result != null) {
                    return result;
                }
                return this.childrenCache.get(element);
            }
        }
        return this.childrenCache.get(element);
    }

    public IJavaElement getExistingElement(IJavaElement element) {
        switch (element.getElementType()) {
            case 1: {
                return element;
            }
            case 2: {
                return element;
            }
            case 3: {
                return this.rootCache.getKey((IPackageFragmentRoot)element);
            }
            case 4: {
                return this.pkgCache.getKey((IPackageFragment)element);
            }
            case 5: 
            case 6: {
                return this.openableCache.getKey((ITypeRoot)element);
            }
            case 7: {
                return element;
            }
        }
        return element;
    }

    protected double getMemoryRatio() {
        if ((int)this.memoryRatio == -1) {
            long maxMemory = Runtime.getRuntime().maxMemory();
            this.memoryRatio = maxMemory == Long.MAX_VALUE ? 4.0 : (double)maxMemory / 6.7108864E7;
        }
        return this.memoryRatio;
    }

    protected Object peekAtInfo(IJavaElement element) {
        switch (element.getElementType()) {
            case 1: {
                return this.modelInfo;
            }
            case 2: {
                return this.projectCache.get(element);
            }
            case 3: {
                return this.rootCache.peek((IPackageFragmentRoot)element);
            }
            case 4: {
                return this.pkgCache.peek((IPackageFragment)element);
            }
            case 5: 
            case 6: {
                return this.openableCache.peek((ITypeRoot)element);
            }
            case 7: {
                Object result = this.jarTypeCache.peek(element);
                if (result != null) {
                    return result;
                }
                return this.childrenCache.get(element);
            }
        }
        return this.childrenCache.get(element);
    }

    protected void putInfo(IJavaElement element, Object info) {
        if (DEBUG_CACHE_INSERTIONS) {
            System.out.println(Thread.currentThread() + " cache putInfo (" + JavaModelCache.getElementType(element) + " " + element.toString() + ", " + info + ")");
        }
        switch (element.getElementType()) {
            case 1: {
                this.modelInfo = (JavaElementInfo)info;
                break;
            }
            case 2: {
                this.projectCache.put((IJavaProject)element, (JavaElementInfo)info);
                this.rootCache.ensureSpaceLimit((JavaElementInfo)info, element);
                break;
            }
            case 3: {
                this.rootCache.put((IPackageFragmentRoot)element, (JavaElementInfo)info);
                this.pkgCache.ensureSpaceLimit((JavaElementInfo)info, element);
                break;
            }
            case 4: {
                this.pkgCache.put((IPackageFragment)element, (JavaElementInfo)info);
                this.openableCache.ensureSpaceLimit((JavaElementInfo)info, element);
                break;
            }
            case 5: 
            case 6: {
                this.openableCache.put((ITypeRoot)element, (JavaElementInfo)info);
                break;
            }
            default: {
                this.childrenCache.put(element, info);
            }
        }
    }

    public static String getElementType(IJavaElement element) {
        String elementType;
        switch (element.getElementType()) {
            case 2: {
                elementType = "project";
                break;
            }
            case 3: {
                elementType = "root";
                break;
            }
            case 4: {
                elementType = "package";
                break;
            }
            case 6: {
                elementType = "class file";
                break;
            }
            case 5: {
                elementType = "compilation unit";
                break;
            }
            default: {
                elementType = "element";
            }
        }
        return elementType;
    }

    protected void removeInfo(JavaElement element) {
        if (DEBUG_CACHE_INSERTIONS) {
            String elementToString = element.toString();
            System.out.println(Thread.currentThread() + " cache removeInfo " + JavaModelCache.getElementType(element) + " " + elementToString);
        }
        switch (element.getElementType()) {
            case 1: {
                this.modelInfo = null;
                break;
            }
            case 2: {
                this.projectCache.remove((IJavaProject)((Object)element));
                this.rootCache.resetSpaceLimit((int)(50.0 * this.getMemoryRatio()), element);
                break;
            }
            case 3: {
                this.rootCache.remove((IPackageFragmentRoot)((Object)element));
                this.pkgCache.resetSpaceLimit((int)(500.0 * this.getMemoryRatio()), element);
                break;
            }
            case 4: {
                this.pkgCache.remove((IPackageFragment)((Object)element));
                this.openableCache.resetSpaceLimit((int)(250.0 * this.getMemoryRatio() * this.getOpenableRatio()), element);
                break;
            }
            case 5: 
            case 6: {
                this.openableCache.remove((ITypeRoot)((Object)element));
                break;
            }
            default: {
                this.childrenCache.remove(element);
            }
        }
    }

    protected void resetJarTypeCache() {
        this.jarTypeCache = new LRUCache((int)(250.0 * this.getMemoryRatio() * this.getJarTypeRatio()));
    }

    protected void removeFromJarTypeCache(BinaryType type) {
        this.jarTypeCache.flush(type);
    }

    public String toString() {
        return this.toStringFillingRation("");
    }

    public String toStringFillingRation(String prefix) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(prefix);
        buffer.append("Project cache: ");
        buffer.append(this.projectCache.size());
        buffer.append(" projects\n");
        buffer.append(prefix);
        buffer.append(this.rootCache.toStringFillingRation("Root cache"));
        buffer.append('\n');
        buffer.append(prefix);
        buffer.append(this.pkgCache.toStringFillingRation("Package cache"));
        buffer.append('\n');
        buffer.append(prefix);
        buffer.append(this.openableCache.toStringFillingRation("Openable cache"));
        buffer.append('\n');
        buffer.append(prefix);
        buffer.append(this.jarTypeCache.toStringFillingRation("Jar type cache"));
        buffer.append('\n');
        return buffer.toString();
    }
}

