/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk8.core.Flags;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IMethod;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IType;
import io.spring.javaformat.eclipse.jdt.jdk8.core.ITypeParameter;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.Signature;
import io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IBinaryAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IBinaryMethod;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IBinaryType;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.Binding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.parser.ScannerHelper;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.BinaryMember;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.BinaryType;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.ClassFile;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaModelManager;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavadocContents;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.NamedMember;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.ResolvedBinaryMethod;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.SourceMapper;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.TypeParameter;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.LRUCache;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.Util;
import org.eclipse.core.runtime.IProgressMonitor;

public class BinaryMethod
extends BinaryMember
implements IMethod {
    protected String[] parameterTypes;
    protected String[] erasedParamaterTypes;
    protected String[] parameterNames;
    protected String returnType;

    protected BinaryMethod(JavaElement parent, String name, String[] paramTypes) {
        super(parent, name);
        this.parameterTypes = paramTypes == null ? CharOperation.NO_STRINGS : paramTypes;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BinaryMethod)) {
            return false;
        }
        return super.equals(o) && Util.equalArraysOrNull(this.getErasedParameterTypes(), ((BinaryMethod)o).getErasedParameterTypes());
    }

    @Override
    public IAnnotation[] getAnnotations() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        IBinaryAnnotation[] binaryAnnotations = info.getAnnotations();
        return this.getAnnotations(binaryAnnotations, info.getTagBits());
    }

    @Override
    public int getElementType() {
        return 9;
    }

    @Override
    public int getFlags() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        int modifiers = info.getModifiers();
        if (((IType)((Object)this.parent)).isInterface() && (modifiers & 0x408) == 0) {
            modifiers |= 0x10000;
        }
        return modifiers;
    }

    @Override
    protected void getHandleMemento(StringBuffer buff) {
        ((JavaElement)this.getParent()).getHandleMemento(buff);
        char delimiter = this.getHandleMementoDelimiter();
        buff.append(delimiter);
        this.escapeMementoName(buff, this.getElementName());
        int i = 0;
        while (i < this.parameterTypes.length) {
            buff.append(delimiter);
            this.escapeMementoName(buff, this.parameterTypes[i]);
            ++i;
        }
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '~';
    }

    @Override
    public String getKey(boolean forceOpen) throws JavaModelException {
        return this.getKey(this, forceOpen);
    }

    @Override
    public int getNumberOfParameters() {
        return this.parameterTypes == null ? 0 : this.parameterTypes.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getParameterNames() throws JavaModelException {
        if (this.parameterNames != null) {
            return this.parameterNames;
        }
        IType type = (IType)this.getParent();
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            char[][] paramNames = mapper.getMethodParameterNames(this);
            if (paramNames == null) {
                IBinaryType info = (IBinaryType)((BinaryType)this.getDeclaringType()).getElementInfo();
                char[] source = mapper.findSource(type, info);
                if (source != null) {
                    mapper.mapSource((NamedMember)((Object)type), source, info);
                }
                paramNames = mapper.getMethodParameterNames(this);
            }
            if (paramNames != null) {
                String[] names = new String[paramNames.length];
                int i = 0;
                while (i < paramNames.length) {
                    names[i] = new String(paramNames[i]);
                    ++i;
                }
                this.parameterNames = names;
                return names;
            }
        }
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        int paramCount = Signature.getParameterCount(new String(info.getMethodDescriptor()));
        if (this.isConstructor()) {
            IType declaringType = this.getDeclaringType();
            if (declaringType.isMember() && !Flags.isStatic(declaringType.getFlags())) {
                --paramCount;
            } else if (declaringType.isEnum() && paramCount >= 2) {
                paramCount -= 2;
            }
        }
        if (paramCount != 0) {
            char[][] argumentNames;
            int modifiers = this.getFlags();
            if ((modifiers & 0x1000) != 0) {
                this.parameterNames = this.getRawParameterNames(paramCount);
                return this.parameterNames;
            }
            JavadocContents javadocContents = null;
            IType declaringType = this.getDeclaringType();
            JavaModelManager.PerProjectInfo projectInfo = JavaModelManager.getJavaModelManager().getPerProjectInfoCheckExistence(this.getJavaProject().getProject());
            LRUCache<IJavaElement, Object> lRUCache = projectInfo.javadocCache;
            synchronized (lRUCache) {
                javadocContents = (JavadocContents)projectInfo.javadocCache.get(declaringType);
                if (javadocContents == null) {
                    projectInfo.javadocCache.put(declaringType, BinaryType.EMPTY_JAVADOC);
                }
            }
            String methodDoc = null;
            if (javadocContents == null) {
                long timeOut = 50L;
                try {
                    String option = this.getJavaProject().getOption("io.spring.javaformat.eclipse.jdt.jdk8.core.timeoutForParameterNameFromAttachedJavadoc", true);
                    if (option != null) {
                        timeOut = Long.parseLong(option);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                if (timeOut == 0L) {
                    return this.getRawParameterNames(paramCount);
                }
                final class ParametersNameCollector {
                    String javadoc;

                    ParametersNameCollector() {
                    }

                    public void setJavadoc(String s) {
                        this.javadoc = s;
                    }

                    public String getJavadoc() {
                        return this.javadoc;
                    }
                }
                final ParametersNameCollector nameCollector = new ParametersNameCollector();
                Thread collect = new Thread(){
                    {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            nameCollector.setJavadoc(BinaryMethod.this.getAttachedJavadoc(null));
                        }
                        catch (JavaModelException javaModelException) {}
                        ParametersNameCollector parametersNameCollector = nameCollector;
                        synchronized (parametersNameCollector) {
                            nameCollector.notify();
                        }
                    }
                };
                collect.start();
                ParametersNameCollector parametersNameCollector = nameCollector;
                synchronized (parametersNameCollector) {
                    try {
                        nameCollector.wait(timeOut);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                methodDoc = nameCollector.getJavadoc();
            } else if (javadocContents != BinaryType.EMPTY_JAVADOC) {
                try {
                    methodDoc = javadocContents.getMethodDoc(this);
                }
                catch (JavaModelException javaModelException) {
                    javadocContents = null;
                }
            }
            if (methodDoc != null) {
                int indexOfClosingParen;
                int indexOfOpenParen = methodDoc.indexOf(40);
                if (info.getAnnotations() != null) {
                    while (indexOfOpenParen != -1 && !this.isOpenParenForMethod(methodDoc, this.getElementName(), indexOfOpenParen)) {
                        indexOfOpenParen = methodDoc.indexOf(40, indexOfOpenParen + 1);
                    }
                }
                if (indexOfOpenParen != -1 && (indexOfClosingParen = methodDoc.indexOf(41, indexOfOpenParen)) != -1) {
                    char[] paramsSource = CharOperation.replace(methodDoc.substring(indexOfOpenParen + 1, indexOfClosingParen).toCharArray(), "&nbsp;".toCharArray(), new char[]{' '});
                    char[][] params = this.splitParameters(paramsSource, paramCount);
                    int paramsLength = params.length;
                    String[] names = new String[paramsLength];
                    int i = 0;
                    while (i < paramsLength) {
                        char[] param = params[i];
                        int indexOfSpace = CharOperation.lastIndexOf(' ', param);
                        names[i] = indexOfSpace != -1 ? String.valueOf(param, indexOfSpace + 1, param.length - indexOfSpace - 1) : "arg" + i;
                        ++i;
                    }
                    this.parameterNames = names;
                    return names;
                }
            }
            if ((argumentNames = info.getArgumentNames()) != null && argumentNames.length == paramCount) {
                String[] names = new String[paramCount];
                int i = 0;
                while (i < paramCount) {
                    names[i] = new String(argumentNames[i]);
                    ++i;
                }
                this.parameterNames = names;
                return names;
            }
        }
        return this.getRawParameterNames(paramCount);
    }

    private boolean isOpenParenForMethod(String javaDoc, String methodName, int index) {
        boolean scanningTag = false;
        int endIndex = 0;
        while (--index > methodName.length()) {
            char previousChar = javaDoc.charAt(index);
            if (endIndex > 0) {
                if (ScannerHelper.isJavaIdentifierPart(previousChar) && ScannerHelper.isJavaIdentifierStart(previousChar)) continue;
                return methodName.equals(javaDoc.substring(index + 1, endIndex));
            }
            if (!scanningTag) {
                if (previousChar == '>') {
                    scanningTag = true;
                    continue;
                }
                if (!ScannerHelper.isJavaIdentifierPart(previousChar) && !ScannerHelper.isJavaIdentifierStart(previousChar)) continue;
                endIndex = index + 1;
                continue;
            }
            if (previousChar != '<') continue;
            scanningTag = false;
        }
        return false;
    }

    private char[][] splitParameters(char[] parametersSource, int paramCount) {
        char[][] params = new char[paramCount][];
        int paramIndex = 0;
        int index = 0;
        int balance = 0;
        int length = parametersSource.length;
        int start = 0;
        block6: while (index < length) {
            switch (parametersSource[index]) {
                case '<': {
                    ++balance;
                    ++index;
                    while (index < length && parametersSource[index] != '>') {
                        ++index;
                    }
                    continue block6;
                }
                case '>': {
                    --balance;
                    ++index;
                    break;
                }
                case ',': {
                    if (balance == 0 && paramIndex < paramCount) {
                        params[paramIndex++] = CharOperation.subarray(parametersSource, start, index);
                        start = index + 1;
                    }
                    ++index;
                    break;
                }
                case '&': {
                    if (index + 4 < length) {
                        if (parametersSource[index + 1] == 'l' && parametersSource[index + 2] == 't' && parametersSource[index + 3] == ';') {
                            ++balance;
                            index += 4;
                            break;
                        }
                        if (parametersSource[index + 1] == 'g' && parametersSource[index + 2] == 't' && parametersSource[index + 3] == ';') {
                            --balance;
                            index += 4;
                            break;
                        }
                        ++index;
                        break;
                    }
                    ++index;
                    break;
                }
                default: {
                    ++index;
                }
            }
        }
        if (paramIndex < paramCount) {
            params[paramIndex++] = CharOperation.subarray(parametersSource, start, index);
        }
        if (paramIndex != paramCount) {
            char[][] cArrayArray = params;
            params = new char[paramIndex][];
            System.arraycopy(cArrayArray, 0, params, 0, paramIndex);
        }
        return params;
    }

    @Override
    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    private String[] getErasedParameterTypes() {
        if (this.erasedParamaterTypes == null) {
            int paramCount = this.parameterTypes.length;
            String[] erasedTypes = new String[paramCount];
            boolean erasureNeeded = false;
            int i = 0;
            while (i < paramCount) {
                String parameterType = this.parameterTypes[i];
                erasedTypes[i] = Signature.getTypeErasure(parameterType);
                if (erasedTypes[i] != parameterType) {
                    erasureNeeded = true;
                }
                ++i;
            }
            this.erasedParamaterTypes = erasureNeeded ? erasedTypes : this.parameterTypes;
        }
        return this.erasedParamaterTypes;
    }

    private String getErasedParameterType(int index) {
        return this.getErasedParameterTypes()[index];
    }

    @Override
    public ITypeParameter getTypeParameter(String typeParameterName) {
        return new TypeParameter(this, typeParameterName);
    }

    @Override
    public ITypeParameter[] getTypeParameters() throws JavaModelException {
        String[] typeParameterSignatures = this.getTypeParameterSignatures();
        int length = typeParameterSignatures.length;
        if (length == 0) {
            return TypeParameter.NO_TYPE_PARAMETERS;
        }
        ITypeParameter[] typeParameters = new ITypeParameter[length];
        int i = 0;
        while (i < typeParameterSignatures.length) {
            String typeParameterName = Signature.getTypeVariable(typeParameterSignatures[i]);
            typeParameters[i] = new TypeParameter(this, typeParameterName);
            ++i;
        }
        return typeParameters;
    }

    public String[] getTypeParameterSignatures() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        char[] genericSignature = info.getGenericSignature();
        if (genericSignature == null) {
            return CharOperation.NO_STRINGS;
        }
        char[] dotBasedSignature = CharOperation.replaceOnCopy(genericSignature, '/', '.');
        char[][] typeParams = Signature.getTypeParameters(dotBasedSignature);
        return CharOperation.toStrings(typeParams);
    }

    private String[] getRawParameterNames(int paramCount) {
        String[] result = new String[paramCount];
        int i = 0;
        while (i < paramCount) {
            result[i] = "arg" + i;
            ++i;
        }
        return result;
    }

    @Override
    public String getReturnType() throws JavaModelException {
        if (this.returnType == null) {
            IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
            this.returnType = this.getReturnType(info);
        }
        return this.returnType;
    }

    private String getReturnType(IBinaryMethod info) {
        char[] genericSignature = info.getGenericSignature();
        char[] signature = genericSignature == null ? info.getMethodDescriptor() : genericSignature;
        char[] dotBasedSignature = CharOperation.replaceOnCopy(signature, '/', '.');
        String returnTypeName = Signature.getReturnType(new String(dotBasedSignature));
        return new String(ClassFile.translatedName(returnTypeName.toCharArray()));
    }

    public String getSignature() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        return new String(info.getMethodDescriptor());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        int i = 0;
        int length = this.parameterTypes.length;
        while (i < length) {
            hash = Util.combineHashCodes(hash, this.getErasedParameterType(i).hashCode());
            ++i;
        }
        return hash;
    }

    @Override
    public boolean isConstructor() throws JavaModelException {
        if (!this.getElementName().equals(this.parent.getElementName())) {
            return false;
        }
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        return info.isConstructor();
    }

    @Override
    public String readableName() {
        int length;
        StringBuffer buffer = new StringBuffer(super.readableName());
        buffer.append("(");
        String[] paramTypes = this.parameterTypes;
        if (paramTypes != null && (length = paramTypes.length) > 0) {
            int i = 0;
            while (i < length) {
                buffer.append(Signature.toString(paramTypes[i]));
                if (i < length - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public JavaElement resolved(Binding binding) {
        ResolvedBinaryMethod resolvedHandle = new ResolvedBinaryMethod(this.parent, this.name, this.parameterTypes, new String(binding.computeUniqueKey()));
        resolvedHandle.occurrenceCount = this.occurrenceCount;
        return resolvedHandle;
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            this.toStringName(buffer);
            buffer.append(" (not open)");
        } else if (info == NO_INFO) {
            this.toStringName(buffer);
        } else {
            IBinaryMethod methodInfo = (IBinaryMethod)info;
            int flags = methodInfo.getModifiers();
            if (Flags.isStatic(flags)) {
                buffer.append("static ");
            }
            if (!methodInfo.isConstructor()) {
                buffer.append(Signature.toString(this.getReturnType(methodInfo)));
                buffer.append(' ');
            }
            this.toStringName(buffer, flags);
        }
    }

    @Override
    protected void toStringName(StringBuffer buffer) {
        this.toStringName(buffer, 0);
    }

    protected void toStringName(StringBuffer buffer, int flags) {
        int length;
        buffer.append(this.getElementName());
        buffer.append('(');
        String[] parameters = this.getParameterTypes();
        if (parameters != null && (length = parameters.length) > 0) {
            boolean isVarargs = Flags.isVarargs(flags);
            int i = 0;
            while (i < length) {
                try {
                    if (i < length - 1) {
                        buffer.append(Signature.toString(parameters[i]));
                        buffer.append(", ");
                    } else if (isVarargs) {
                        String parameter = parameters[i].substring(1);
                        buffer.append(Signature.toString(parameter));
                        buffer.append(" ...");
                    } else {
                        buffer.append(Signature.toString(parameters[i]));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    buffer.append("*** invalid signature: ");
                    buffer.append(parameters[i]);
                }
                ++i;
            }
        }
        buffer.append(')');
        if (this.occurrenceCount > 1) {
            buffer.append("#");
            buffer.append(this.occurrenceCount);
        }
    }

    @Override
    public String getAttachedJavadoc(IProgressMonitor monitor) throws JavaModelException {
        JavadocContents javadocContents = ((BinaryType)this.getDeclaringType()).getJavadocContents(monitor);
        if (javadocContents == null) {
            return null;
        }
        return javadocContents.getMethodDoc(this);
    }
}

