/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.formatter.jdk17.eclipse;

import io.spring.javaformat.eclipse.jdt.jdk17.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk17.core.dom.ASTVisitor;
import io.spring.javaformat.eclipse.jdt.jdk17.core.dom.Annotation;
import io.spring.javaformat.eclipse.jdt.jdk17.core.dom.CompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk17.core.dom.FieldDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk17.core.dom.IExtendedModifier;
import io.spring.javaformat.eclipse.jdt.jdk17.core.dom.ImportDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk17.core.dom.MethodDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk17.core.dom.SingleVariableDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk17.core.dom.VariableDeclarationStatement;
import io.spring.javaformat.eclipse.jdt.jdk17.internal.formatter.Preparator;
import io.spring.javaformat.eclipse.jdt.jdk17.internal.formatter.TokenManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class JSpecifyPreparator
implements Preparator {
    private static final String PACKAGE_NAME = "org.jspecify.annotations";
    private static final Set<String> ANNOTATION_NAMES = new HashSet<String>(Arrays.asList("NonNull", "Nullable"));
    private static final Set<String> FULLY_QUALIFIED_ANNOTATION_NAMES = ANNOTATION_NAMES.stream().map(annotationName -> "org.jspecify.annotations." + annotationName).collect(Collectors.toSet());

    public void apply(int kind, TokenManager tokenManager, ASTNode astRoot) {
        if ((kind & 8) != 0) {
            Vistor visitor = new Vistor(tokenManager);
            astRoot.accept((ASTVisitor)visitor);
        }
    }

    private static class Vistor
    extends ASTVisitor {
        private final TokenManager tokenManager;
        private final Map<String, String> fullyQualified = new HashMap<String, String>();

        Vistor(TokenManager tokenManager) {
            this.tokenManager = tokenManager;
        }

        public boolean visit(CompilationUnit node) {
            this.fullyQualified.clear();
            return super.visit(node);
        }

        public boolean visit(ImportDeclaration node) {
            String name = node.getName().toString();
            if (name.equals(JSpecifyPreparator.PACKAGE_NAME) || name.startsWith(JSpecifyPreparator.PACKAGE_NAME)) {
                Set<String> annotationNames = node.isOnDemand() ? ANNOTATION_NAMES : Collections.singleton(name.substring(name.lastIndexOf(".") + 1));
                for (String annotationName : annotationNames) {
                    this.fullyQualified.put(annotationName, "org.jspecify.annotations." + annotationName);
                }
            }
            return super.visit(node);
        }

        public boolean visit(FieldDeclaration node) {
            this.clearLineBreaksIfHasJSpecifyAnnotation(node.modifiers());
            return super.visit(node);
        }

        public boolean visit(MethodDeclaration node) {
            this.clearLineBreaksIfHasJSpecifyAnnotation(node.modifiers());
            return true;
        }

        public boolean visit(VariableDeclarationStatement node) {
            this.clearLineBreaksIfHasJSpecifyAnnotation(node.modifiers());
            return true;
        }

        public void endVisit(SingleVariableDeclaration node) {
            List annotations;
            Annotation lastAnnotation;
            if (node.isVarargs() && this.isJSpecifyAnnotation(lastAnnotation = this.getLastAnnotation(annotations = node.varargsAnnotations()))) {
                this.tokenManager.lastTokenIn((ASTNode)lastAnnotation, -1).spaceAfter();
            }
        }

        private void clearLineBreaksIfHasJSpecifyAnnotation(List<?> modifiers) {
            Annotation lastAnnotation = this.getLastAnnotation(modifiers);
            if (this.isJSpecifyAnnotation(lastAnnotation)) {
                this.tokenManager.lastTokenIn((ASTNode)lastAnnotation, -1).clearLineBreaksAfter();
            }
        }

        private Annotation getLastAnnotation(List<? extends IExtendedModifier> modifiers) {
            Annotation annotation = null;
            for (IExtendedModifier iExtendedModifier : modifiers) {
                if (!iExtendedModifier.isAnnotation()) {
                    return annotation;
                }
                annotation = (Annotation)iExtendedModifier;
            }
            return annotation;
        }

        private boolean isJSpecifyAnnotation(Annotation annotation) {
            String fullyQualifiedName = annotation != null ? this.fullyQualified.get(annotation.getTypeName().toString()) : null;
            return fullyQualifiedName != null && FULLY_QUALIFIED_ANNOTATION_NAMES.contains(fullyQualifiedName);
        }
    }
}

