/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.formatter;

import io.spring.javaformat.config.JavaBaseline;
import io.spring.javaformat.config.JavaFormatConfig;
import io.spring.javaformat.formatter.eclipse.EclipseCodeFormatter;
import io.spring.javaformat.formatter.jdk17.eclipse.EclipseJdk17CodeFormatter;
import io.spring.javaformat.formatter.jdk8.eclipse.EclipseJdk8CodeFormatter;
import java.util.Map;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.TextEdit;

public class Formatter {
    private static final int K_COMPILATION_UNIT = 8;
    private static final int F_INCLUDE_COMMENTS = 4096;
    private static final int DEFAULT_COMPONENTS = 4104;
    private static final int DEFAULT_INDENTATION_LEVEL = 0;
    public static final String DEFAULT_LINE_SEPARATOR = null;
    private final EclipseCodeFormatter delegate;

    public Formatter() {
        this(JavaFormatConfig.DEFAULT);
    }

    public Formatter(JavaFormatConfig javaFormatConfig) {
        this.delegate = javaFormatConfig.getJavaBaseline() == JavaBaseline.V8 ? new EclipseJdk8CodeFormatter(javaFormatConfig) : new EclipseJdk17CodeFormatter(javaFormatConfig);
    }

    public TextEdit format(String source) {
        return this.format(source, DEFAULT_LINE_SEPARATOR);
    }

    public TextEdit format(String source, String lineSeparator) {
        return this.format(source, 0, source.length(), lineSeparator);
    }

    public TextEdit format(String source, int offset, int length) {
        return this.format(source, offset, length, DEFAULT_LINE_SEPARATOR);
    }

    public TextEdit format(String source, int offset, int length, String lineSeparator) {
        return this.format(4104, source, offset, length, 0, lineSeparator);
    }

    public TextEdit format(int kind, String source, int offset, int length, int indentationLevel, String lineSeparator) {
        lineSeparator = lineSeparator != null ? lineSeparator : this.detectLineSeparator(source);
        return this.delegate.format(kind, source, offset, length, indentationLevel, lineSeparator);
    }

    public TextEdit format(String source, IRegion[] regions) {
        return this.format(source, regions, DEFAULT_LINE_SEPARATOR);
    }

    public TextEdit format(String source, IRegion[] regions, String lineSeparator) {
        return this.format(4104, source, regions, 0, lineSeparator);
    }

    public TextEdit format(int kind, String source, IRegion[] regions, int indentationLevel, String lineSeparator) {
        lineSeparator = lineSeparator != null ? lineSeparator : this.detectLineSeparator(source);
        return this.delegate.format(kind, source, regions, indentationLevel, lineSeparator);
    }

    public String createIndentationString(int indentationLevel) {
        return this.delegate.createIndentationString(indentationLevel);
    }

    public void setOptions(Map<String, String> options) {
        this.delegate.setOptions(options);
    }

    private String detectLineSeparator(String contents) {
        int length = contents.length();
        for (int i = 0; i < length; ++i) {
            boolean isLastChar;
            char ch = contents.charAt(i);
            boolean bl = isLastChar = i + 1 == length;
            if (ch == '\r') {
                return isLastChar || contents.charAt(i + 1) != '\n' ? "\r" : "\r\n";
            }
            if (ch != '\n') continue;
            return "\n";
        }
        return null;
    }
}

