/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.undertow.UndertowLogger;
import io.undertow.httpcore.HttpExchange;
import io.undertow.httpcore.IoCallback;
import io.undertow.httpcore.OutputChannel;
import io.undertow.httpcore.WriteFunction;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.cache.LimitedBufferSlicePool;
import io.undertow.server.handlers.resource.CachingResourceManager;
import io.undertow.server.handlers.resource.RangeAwareResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.util.DateUtils;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;

public class CachedResource
implements Resource,
RangeAwareResource {
    private final CacheKey cacheKey;
    private final CachingResourceManager cachingResourceManager;
    private final Resource underlyingResource;
    private final boolean directory;
    private final Date lastModifiedDate;
    private final String lastModifiedDateString;
    private final ETag eTag;
    private final String name;
    private volatile long nextMaxAgeCheck;

    public CachedResource(CachingResourceManager cachingResourceManager, Resource underlyingResource, String path) {
        this.cachingResourceManager = cachingResourceManager;
        this.underlyingResource = underlyingResource;
        this.directory = underlyingResource.isDirectory();
        this.lastModifiedDate = underlyingResource.getLastModified();
        this.lastModifiedDateString = this.lastModifiedDate != null ? DateUtils.toDateString(this.lastModifiedDate) : null;
        this.eTag = underlyingResource.getETag();
        this.name = underlyingResource.getName();
        this.cacheKey = new CacheKey(cachingResourceManager, underlyingResource.getCacheKey());
        this.nextMaxAgeCheck = cachingResourceManager.getMaxAge() > 0 ? System.currentTimeMillis() + (long)cachingResourceManager.getMaxAge() : -1L;
    }

    @Override
    public String getPath() {
        return this.underlyingResource.getPath();
    }

    @Override
    public Date getLastModified() {
        return this.lastModifiedDate;
    }

    @Override
    public String getLastModifiedString() {
        return this.lastModifiedDateString;
    }

    @Override
    public ETag getETag() {
        return this.eTag;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDirectory() {
        return this.directory;
    }

    @Override
    public List<Resource> list() {
        return this.underlyingResource.list();
    }

    @Override
    public String getContentType(MimeMappings mimeMappings) {
        return this.underlyingResource.getContentType(mimeMappings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serveBlocking(OutputStream outputStream, HttpServerExchange exchange) throws IOException {
        DirectBufferCache dataCache = this.cachingResourceManager.getDataCache();
        if (dataCache == null) {
            this.underlyingResource.serveBlocking(outputStream, exchange);
            return;
        }
        DirectBufferCache.CacheEntry existing = dataCache.get(this.cacheKey);
        Long length = this.getContentLength();
        if (length == null || length > this.cachingResourceManager.getMaxFileSize()) {
            this.underlyingResource.serveBlocking(outputStream, exchange);
            return;
        }
        if (existing == null || !existing.enabled() || !existing.reference()) {
            DirectBufferCache.CacheEntry entry = existing == null ? dataCache.add(this.cacheKey, length.intValue(), this.cachingResourceManager.getMaxAge()) : existing;
            if (entry != null && entry.buffers().length != 0 && entry.claimEnable()) {
                if (entry.reference()) {
                    DirectBufferCache.CacheEntry cacheEntry = entry;
                    exchange.addWriteFunction(new CachingWriteFunction(cacheEntry, length));
                } else {
                    entry.disable();
                }
            }
            this.underlyingResource.serveBlocking(outputStream, exchange);
        } else {
            ByteBuf[] buffers;
            UndertowLogger.REQUEST_LOGGER.tracef("Serving resource %s from the buffer cache to %s", this.name, exchange);
            boolean ok = false;
            try {
                LimitedBufferSlicePool.PooledByteBuffer[] pooled = existing.buffers();
                buffers = new ByteBuf[pooled.length];
                for (int i = 0; i < buffers.length; ++i) {
                    buffers[i] = pooled[i].getBuffer().duplicate();
                }
                ok = true;
            }
            finally {
                if (!ok) {
                    existing.dereference();
                }
            }
            try {
                for (ByteBuf i : buffers) {
                    while (i.isReadable()) {
                        outputStream.write(i.readByte());
                    }
                }
                outputStream.close();
            }
            finally {
                existing.dereference();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serveAsync(OutputChannel stream, HttpServerExchange exchange) {
        DirectBufferCache dataCache = this.cachingResourceManager.getDataCache();
        if (dataCache == null) {
            this.underlyingResource.serveAsync(stream, exchange);
            return;
        }
        DirectBufferCache.CacheEntry existing = dataCache.get(this.cacheKey);
        Long length = this.getContentLength();
        if (length == null || length > this.cachingResourceManager.getMaxFileSize()) {
            this.underlyingResource.serveAsync(stream, exchange);
            return;
        }
        if (existing == null || !existing.enabled() || !existing.reference()) {
            DirectBufferCache.CacheEntry entry = existing == null ? dataCache.add(this.cacheKey, length.intValue(), this.cachingResourceManager.getMaxAge()) : existing;
            if (entry != null && entry.buffers().length != 0 && entry.claimEnable()) {
                if (entry.reference()) {
                    DirectBufferCache.CacheEntry cacheEntry = entry;
                    exchange.addWriteFunction(new CachingWriteFunction(cacheEntry, length));
                } else {
                    entry.disable();
                }
            }
            this.underlyingResource.serveAsync(stream, exchange);
        } else {
            ByteBuf[] buffers;
            UndertowLogger.REQUEST_LOGGER.tracef("Serving resource %s from the buffer cache to %s", this.name, exchange);
            boolean ok = false;
            try {
                LimitedBufferSlicePool.PooledByteBuffer[] pooled = existing.buffers();
                buffers = new ByteBuf[pooled.length];
                for (int i = 0; i < buffers.length; ++i) {
                    buffers[i] = pooled[i].getBuffer().duplicate();
                }
                ok = true;
            }
            finally {
                if (!ok) {
                    existing.dereference();
                }
            }
            stream.writeAsync(Unpooled.wrappedBuffer((ByteBuf[])buffers), true, new DereferenceCallback(existing, IoCallback.END_EXCHANGE), null);
        }
    }

    public void invalidate() {
        DirectBufferCache dataCache = this.cachingResourceManager.getDataCache();
        if (dataCache != null) {
            dataCache.remove(this.cacheKey);
        }
    }

    public boolean checkStillValid() {
        long time;
        if (this.nextMaxAgeCheck > 0L && (time = System.currentTimeMillis()) > this.nextMaxAgeCheck) {
            this.nextMaxAgeCheck = time + (long)this.cachingResourceManager.getMaxAge();
            if (!this.underlyingResource.getLastModified().equals(this.lastModifiedDate)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Long getContentLength() {
        DirectBufferCache dataCache = this.cachingResourceManager.getDataCache();
        if (dataCache == null) {
            return this.underlyingResource.getContentLength();
        }
        DirectBufferCache.CacheEntry existing = dataCache.get(this.cacheKey);
        if (existing == null || !existing.enabled()) {
            return this.underlyingResource.getContentLength();
        }
        return existing.size();
    }

    @Override
    public String getCacheKey() {
        return this.cacheKey.cacheKey;
    }

    @Override
    public File getFile() {
        return this.underlyingResource.getFile();
    }

    @Override
    public Path getFilePath() {
        return this.underlyingResource.getFilePath();
    }

    @Override
    public File getResourceManagerRoot() {
        return this.underlyingResource.getResourceManagerRoot();
    }

    @Override
    public Path getResourceManagerRootPath() {
        return this.underlyingResource.getResourceManagerRootPath();
    }

    @Override
    public URL getUrl() {
        return this.underlyingResource.getUrl();
    }

    @Override
    public void serveRangeBlocking(OutputStream outputStream, HttpServerExchange exchange, long start, long end) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serveRangeAsync(OutputChannel sender, HttpServerExchange exchange, long start, long end) {
        DirectBufferCache dataCache = this.cachingResourceManager.getDataCache();
        if (dataCache == null) {
            ((RangeAwareResource)this.underlyingResource).serveRangeAsync(sender, exchange, start, end);
            return;
        }
        DirectBufferCache.CacheEntry existing = dataCache.get(this.cacheKey);
        Long length = this.getContentLength();
        if (length == null || length > this.cachingResourceManager.getMaxFileSize()) {
            ((RangeAwareResource)this.underlyingResource).serveRangeAsync(sender, exchange, start, end);
            return;
        }
        if (existing == null || !existing.enabled() || !existing.reference()) {
            ((RangeAwareResource)this.underlyingResource).serveRangeAsync(sender, exchange, start, end);
        } else {
            ByteBuf[] buffers;
            boolean ok = false;
            try {
                LimitedBufferSlicePool.PooledByteBuffer[] pooled = existing.buffers();
                buffers = new ByteBuf[pooled.length];
                for (int i = 0; i < buffers.length; ++i) {
                    buffers[i] = pooled[i].getBuffer().duplicate();
                }
                ok = true;
            }
            finally {
                if (!ok) {
                    existing.dereference();
                }
            }
            if (start > 0L) {
                long startDec = start;
                long endCount = 0L;
                for (ByteBuf b : buffers) {
                    if (endCount == end) {
                        b.clear();
                        continue;
                    }
                    if (endCount + (long)b.readableBytes() < end) {
                        endCount += (long)b.readableBytes();
                    } else {
                        b.writerIndex((int)((long)b.readerIndex() + (end - endCount)));
                        endCount = end;
                    }
                    if ((long)b.readableBytes() >= startDec) {
                        startDec = 0L;
                        b.readerIndex((int)((long)b.readerIndex() + startDec));
                        continue;
                    }
                    startDec -= (long)b.readableBytes();
                    b.clear();
                }
            }
            sender.writeAsync(Unpooled.wrappedBuffer((ByteBuf[])buffers), true, new DereferenceCallback(existing, IoCallback.END_EXCHANGE), null);
        }
    }

    @Override
    public boolean isRangeSupported() {
        return this.underlyingResource instanceof RangeAwareResource && ((RangeAwareResource)this.underlyingResource).isRangeSupported();
    }

    private static class CachingWriteFunction
    implements WriteFunction {
        private final DirectBufferCache.CacheEntry cacheEntry;
        private final Long length;
        int written;

        public CachingWriteFunction(DirectBufferCache.CacheEntry cacheEntry, Long length) {
            this.cacheEntry = cacheEntry;
            this.length = length;
        }

        public ByteBuf preWrite(ByteBuf data, boolean last) {
            ByteBuf copy = data.duplicate();
            LimitedBufferSlicePool.PooledByteBuffer[] pooled = this.cacheEntry.buffers();
            ByteBuf[] buffers = new ByteBuf[pooled.length];
            for (int i = 0; i < buffers.length; ++i) {
                ByteBuf buf = pooled[i].getBuffer();
                if (buf.isWritable()) {
                    int write = Math.min(buf.writableBytes(), copy.readableBytes());
                    this.written += write;
                    buf.writeBytes(copy);
                }
                if (!copy.isReadable()) break;
            }
            if ((long)this.written == this.length) {
                this.cacheEntry.enable();
            }
            return data;
        }
    }

    static final class CacheKey {
        final CachingResourceManager manager;
        final String cacheKey;

        CacheKey(CachingResourceManager manager, String cacheKey) {
            this.manager = manager;
            this.cacheKey = cacheKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey1 = (CacheKey)o;
            if (this.cacheKey != null ? !this.cacheKey.equals(cacheKey1.cacheKey) : cacheKey1.cacheKey != null) {
                return false;
            }
            return !(this.manager != null ? !this.manager.equals(cacheKey1.manager) : cacheKey1.manager != null);
        }

        public int hashCode() {
            int result = this.manager != null ? this.manager.hashCode() : 0;
            result = 31 * result + (this.cacheKey != null ? this.cacheKey.hashCode() : 0);
            return result;
        }
    }

    private static class DereferenceCallback<T>
    implements IoCallback<T> {
        private final DirectBufferCache.CacheEntry entry;
        private final IoCallback<T> callback;

        DereferenceCallback(DirectBufferCache.CacheEntry entry, IoCallback<T> callback) {
            this.entry = entry;
            this.callback = callback;
        }

        public void onComplete(HttpExchange exchange, T sender) {
            try {
                this.entry.dereference();
            }
            finally {
                this.callback.onComplete(exchange, sender);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(HttpExchange exchange, T sender, IOException exception) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(exception);
            try {
                this.entry.dereference();
            }
            finally {
                this.callback.onException(exchange, sender, exception);
            }
        }
    }
}

