/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Signal;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class FluxSwitchOnFirst<T, R>
extends FluxOperator<T, R> {
    static final int STATE_INIT = 0;
    static final int STATE_SUBSCRIBED_ONCE = 1;
    static final int STATE_REQUESTED_ONCE = 2;
    final BiFunction<Signal<? extends T>, Flux<T>, Publisher<? extends R>> transformer;

    FluxSwitchOnFirst(Flux<? extends T> source, BiFunction<Signal<? extends T>, Flux<T>, Publisher<? extends R>> transformer) {
        super(source);
        this.transformer = Objects.requireNonNull(transformer, "transformer");
    }

    @Override
    public int getPrefetch() {
        return 1;
    }

    @Override
    public void subscribe(CoreSubscriber<? super R> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            this.source.subscribe(new SwitchOnFirstConditionalInner<T, R>((Fuseable.ConditionalSubscriber)actual, this.transformer));
            return;
        }
        this.source.subscribe(new SwitchOnFirstInner<T, R>(actual, this.transformer));
    }

    static final class SwitchOnFirstConditionalInner<T, R>
    extends Flux<T>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, R> {
        final Fuseable.ConditionalSubscriber<? super R> outer;
        final BiFunction<Signal<? extends T>, Flux<T>, Publisher<? extends R>> transformer;
        Subscription s;
        Throwable throwable;
        volatile T first;
        volatile boolean done;
        volatile boolean cancelled;
        volatile Fuseable.ConditionalSubscriber<? super T> inner;
        static final AtomicReferenceFieldUpdater<SwitchOnFirstConditionalInner, Fuseable.ConditionalSubscriber> INNER = AtomicReferenceFieldUpdater.newUpdater(SwitchOnFirstConditionalInner.class, Fuseable.ConditionalSubscriber.class, "inner");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<SwitchOnFirstConditionalInner> WIP = AtomicIntegerFieldUpdater.newUpdater(SwitchOnFirstConditionalInner.class, "wip");
        volatile int state;
        static final AtomicIntegerFieldUpdater<SwitchOnFirstConditionalInner> STATE = AtomicIntegerFieldUpdater.newUpdater(SwitchOnFirstConditionalInner.class, "state");

        SwitchOnFirstConditionalInner(Fuseable.ConditionalSubscriber<? super R> outer, BiFunction<Signal<? extends T>, Flux<T>, Publisher<? extends R>> transformer) {
            this.outer = outer;
            this.transformer = transformer;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.CANCELLED) {
                return this.cancelled;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done || this.cancelled;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public Context currentContext() {
            Fuseable.ConditionalSubscriber<T> actual = this.inner;
            if (actual != null) {
                return actual.currentContext();
            }
            return this.outer.currentContext();
        }

        @Override
        public CoreSubscriber<? super R> actual() {
            return this.outer;
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.cancel();
                if (WIP.getAndIncrement(this) == 0) {
                    INNER.lazySet(this, null);
                    T f = this.first;
                    if (f != null) {
                        this.first = null;
                        Operators.onDiscard(f, this.currentContext());
                    }
                }
            }
        }

        @Override
        public void subscribe(CoreSubscriber<? super T> actual) {
            if (this.state == 0 && STATE.compareAndSet(this, 0, 1)) {
                if (this.first == null && this.done) {
                    if (this.throwable != null) {
                        Operators.error(actual, this.throwable);
                    } else {
                        Operators.complete(actual);
                    }
                    return;
                }
                INNER.lazySet(this, Operators.toConditionalSubscriber(actual));
                actual.onSubscribe(this);
            } else {
                Operators.error(actual, new IllegalStateException("FluxSwitchOnFirst allows only one Subscriber"));
            }
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                s.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, this.currentContext());
                return false;
            }
            Fuseable.ConditionalSubscriber<T> i = this.inner;
            if (i == null) {
                Publisher<? extends R> result;
                Fuseable.ConditionalSubscriber<R> o = this.outer;
                try {
                    result = Objects.requireNonNull(this.transformer.apply(Signal.next(t, o.currentContext()), this), "The transformer returned a null value");
                }
                catch (Throwable e) {
                    this.done = true;
                    Operators.error(o, Operators.onOperatorError(this.s, e, t, o.currentContext()));
                    return false;
                }
                this.first = t;
                result.subscribe(o);
                return true;
            }
            return i.tryOnNext(t);
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, this.currentContext());
                return;
            }
            Fuseable.ConditionalSubscriber<? super T> i = this.inner;
            if (i == null) {
                Publisher<? extends R> result;
                Fuseable.ConditionalSubscriber<R> o = this.outer;
                try {
                    result = Objects.requireNonNull(this.transformer.apply(Signal.next(t, o.currentContext()), this), "The transformer returned a null value");
                }
                catch (Throwable e) {
                    this.done = true;
                    Operators.error(o, Operators.onOperatorError(this.s, e, t, o.currentContext()));
                    return;
                }
                this.first = t;
                result.subscribe(o);
                return;
            }
            i.onNext(t);
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.currentContext());
                return;
            }
            this.throwable = t;
            this.done = true;
            Fuseable.ConditionalSubscriber<? super T> i = this.inner;
            T f = this.first;
            if (f == null && i == null) {
                Publisher<? extends R> result;
                Fuseable.ConditionalSubscriber<R> o = this.outer;
                try {
                    result = Objects.requireNonNull(this.transformer.apply(Signal.error(t, o.currentContext()), this), "The transformer returned a null value");
                }
                catch (Throwable e) {
                    this.done = true;
                    Operators.error(o, Operators.onOperatorError(this.s, e, t, o.currentContext()));
                    return;
                }
                result.subscribe(o);
                return;
            }
            if (f == null) {
                this.drainRegular();
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            Fuseable.ConditionalSubscriber<? super T> i = this.inner;
            T f = this.first;
            if (f == null && i == null) {
                Publisher<? extends R> result;
                Fuseable.ConditionalSubscriber<R> o = this.outer;
                try {
                    result = Objects.requireNonNull(this.transformer.apply(Signal.complete(o.currentContext()), this), "The transformer returned a null value");
                }
                catch (Throwable e) {
                    this.done = true;
                    Operators.error(o, Operators.onOperatorError(this.s, e, null, o.currentContext()));
                    return;
                }
                result.subscribe(o);
                return;
            }
            if (f == null) {
                this.drainRegular();
            }
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                if (this.state == 1 && STATE.compareAndSet(this, 1, 2)) {
                    boolean sent = false;
                    if (this.first != null) {
                        sent = this.drainRegular();
                    }
                    if (sent && n != Long.MAX_VALUE) {
                        if (--n > 0L) {
                            this.s.request(n);
                            return;
                        }
                        return;
                    }
                }
                this.s.request(n);
            }
        }

        boolean drainRegular() {
            if (WIP.getAndIncrement(this) != 0) {
                return false;
            }
            T f = this.first;
            int m = 1;
            boolean sent = false;
            Fuseable.ConditionalSubscriber<? super T> a = this.inner;
            do {
                if (f != null) {
                    this.first = null;
                    if (this.cancelled) {
                        Operators.onDiscard(f, a.currentContext());
                        return true;
                    }
                    sent = a.tryOnNext((T)f);
                    f = null;
                }
                if (this.cancelled) {
                    return sent;
                }
                if (!this.done) continue;
                Throwable t = this.throwable;
                if (t != null) {
                    a.onError(t);
                } else {
                    a.onComplete();
                }
                return sent;
            } while ((m = WIP.addAndGet(this, -m)) != 0);
            return sent;
        }
    }

    static final class SwitchOnFirstInner<T, R>
    extends Flux<T>
    implements InnerOperator<T, R> {
        final CoreSubscriber<? super R> outer;
        final BiFunction<Signal<? extends T>, Flux<T>, Publisher<? extends R>> transformer;
        Subscription s;
        Throwable throwable;
        volatile T first;
        volatile boolean done;
        volatile boolean cancelled;
        volatile CoreSubscriber<? super T> inner;
        static final AtomicReferenceFieldUpdater<SwitchOnFirstInner, CoreSubscriber> INNER = AtomicReferenceFieldUpdater.newUpdater(SwitchOnFirstInner.class, CoreSubscriber.class, "inner");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<SwitchOnFirstInner> WIP = AtomicIntegerFieldUpdater.newUpdater(SwitchOnFirstInner.class, "wip");
        volatile int state;
        static final AtomicIntegerFieldUpdater<SwitchOnFirstInner> STATE = AtomicIntegerFieldUpdater.newUpdater(SwitchOnFirstInner.class, "state");

        SwitchOnFirstInner(CoreSubscriber<? super R> outer, BiFunction<Signal<? extends T>, Flux<T>, Publisher<? extends R>> transformer) {
            this.outer = outer;
            this.transformer = transformer;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.CANCELLED) {
                return this.cancelled;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done || this.cancelled;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public CoreSubscriber<? super R> actual() {
            return this.outer;
        }

        @Override
        public Context currentContext() {
            CoreSubscriber<T> actual = this.inner;
            if (actual != null) {
                return actual.currentContext();
            }
            return this.outer.currentContext();
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.cancel();
                if (WIP.getAndIncrement(this) == 0) {
                    INNER.lazySet(this, null);
                    T f = this.first;
                    if (f != null) {
                        this.first = null;
                        Operators.onDiscard(f, this.currentContext());
                    }
                }
            }
        }

        @Override
        public void subscribe(CoreSubscriber<? super T> actual) {
            if (this.state == 0 && STATE.compareAndSet(this, 0, 1)) {
                if (this.first == null && this.done) {
                    if (this.throwable != null) {
                        Operators.error(actual, this.throwable);
                    } else {
                        Operators.complete(actual);
                    }
                    return;
                }
                INNER.lazySet(this, actual);
                actual.onSubscribe(this);
            } else {
                Operators.error(actual, new IllegalStateException("FluxSwitchOnFirst allows only one Subscriber"));
            }
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                s.request(1L);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, this.currentContext());
                return;
            }
            CoreSubscriber<? super T> i = this.inner;
            if (i == null) {
                Publisher<? extends R> result;
                CoreSubscriber<R> o = this.outer;
                try {
                    result = Objects.requireNonNull(this.transformer.apply(Signal.next(t, o.currentContext()), this), "The transformer returned a null value");
                }
                catch (Throwable e) {
                    this.done = true;
                    Operators.error(o, Operators.onOperatorError(this.s, e, t, o.currentContext()));
                    return;
                }
                this.first = t;
                result.subscribe(o);
                return;
            }
            i.onNext(t);
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.currentContext());
                return;
            }
            this.throwable = t;
            this.done = true;
            CoreSubscriber<? super T> i = this.inner;
            T f = this.first;
            if (f == null && i == null) {
                Publisher<? extends R> result;
                CoreSubscriber<R> o = this.outer;
                try {
                    result = Objects.requireNonNull(this.transformer.apply(Signal.error(t, o.currentContext()), this), "The transformer returned a null value");
                }
                catch (Throwable e) {
                    this.done = true;
                    Operators.error(o, Operators.onOperatorError(this.s, e, t, o.currentContext()));
                    return;
                }
                result.subscribe(o);
                return;
            }
            if (f == null) {
                this.drainRegular();
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            CoreSubscriber<? super T> i = this.inner;
            T f = this.first;
            if (f == null && i == null) {
                Publisher<? extends R> result;
                CoreSubscriber<R> o = this.outer;
                try {
                    result = Objects.requireNonNull(this.transformer.apply(Signal.complete(o.currentContext()), this), "The transformer returned a null value");
                }
                catch (Throwable e) {
                    this.done = true;
                    Operators.error(o, Operators.onOperatorError(this.s, e, null, o.currentContext()));
                    return;
                }
                result.subscribe(o);
                return;
            }
            if (f == null) {
                this.drainRegular();
            }
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                if (this.state == 1 && STATE.compareAndSet(this, 1, 2)) {
                    if (this.first != null) {
                        this.drainRegular();
                    }
                    if (n != Long.MAX_VALUE) {
                        if (--n > 0L) {
                            this.s.request(n);
                            return;
                        }
                        return;
                    }
                }
                this.s.request(n);
            }
        }

        void drainRegular() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            T f = this.first;
            int m = 1;
            CoreSubscriber<? super T> a = this.inner;
            do {
                if (f != null) {
                    this.first = null;
                    if (this.cancelled) {
                        Operators.onDiscard(f, a.currentContext());
                        return;
                    }
                    a.onNext(f);
                    f = null;
                }
                if (this.cancelled) {
                    return;
                }
                if (!this.done) continue;
                Throwable t = this.throwable;
                if (t != null) {
                    a.onError(t);
                } else {
                    a.onComplete();
                }
                return;
            } while ((m = WIP.addAndGet(this, -m)) != 0);
        }
    }
}

