/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.EventsV1EventSeries;
import io.kubernetes.client.openapi.models.V1EventSource;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class EventsV1Event
implements KubernetesObject {
    public static final String SERIALIZED_NAME_ACTION = "action";
    @SerializedName(value="action")
    private String action;
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_DEPRECATED_COUNT = "deprecatedCount";
    @SerializedName(value="deprecatedCount")
    private Integer deprecatedCount;
    public static final String SERIALIZED_NAME_DEPRECATED_FIRST_TIMESTAMP = "deprecatedFirstTimestamp";
    @SerializedName(value="deprecatedFirstTimestamp")
    private OffsetDateTime deprecatedFirstTimestamp;
    public static final String SERIALIZED_NAME_DEPRECATED_LAST_TIMESTAMP = "deprecatedLastTimestamp";
    @SerializedName(value="deprecatedLastTimestamp")
    private OffsetDateTime deprecatedLastTimestamp;
    public static final String SERIALIZED_NAME_DEPRECATED_SOURCE = "deprecatedSource";
    @SerializedName(value="deprecatedSource")
    private V1EventSource deprecatedSource;
    public static final String SERIALIZED_NAME_EVENT_TIME = "eventTime";
    @SerializedName(value="eventTime")
    private OffsetDateTime eventTime;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_NOTE = "note";
    @SerializedName(value="note")
    private String note;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;
    public static final String SERIALIZED_NAME_REGARDING = "regarding";
    @SerializedName(value="regarding")
    private V1ObjectReference regarding;
    public static final String SERIALIZED_NAME_RELATED = "related";
    @SerializedName(value="related")
    private V1ObjectReference related;
    public static final String SERIALIZED_NAME_REPORTING_CONTROLLER = "reportingController";
    @SerializedName(value="reportingController")
    private String reportingController;
    public static final String SERIALIZED_NAME_REPORTING_INSTANCE = "reportingInstance";
    @SerializedName(value="reportingInstance")
    private String reportingInstance;
    public static final String SERIALIZED_NAME_SERIES = "series";
    @SerializedName(value="series")
    private EventsV1EventSeries series;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public EventsV1Event action(String action) {
        this.action = action;
        return this;
    }

    @Nullable
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public EventsV1Event apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    @Nullable
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public EventsV1Event deprecatedCount(Integer deprecatedCount) {
        this.deprecatedCount = deprecatedCount;
        return this;
    }

    @Nullable
    public Integer getDeprecatedCount() {
        return this.deprecatedCount;
    }

    public void setDeprecatedCount(Integer deprecatedCount) {
        this.deprecatedCount = deprecatedCount;
    }

    public EventsV1Event deprecatedFirstTimestamp(OffsetDateTime deprecatedFirstTimestamp) {
        this.deprecatedFirstTimestamp = deprecatedFirstTimestamp;
        return this;
    }

    @Nullable
    public OffsetDateTime getDeprecatedFirstTimestamp() {
        return this.deprecatedFirstTimestamp;
    }

    public void setDeprecatedFirstTimestamp(OffsetDateTime deprecatedFirstTimestamp) {
        this.deprecatedFirstTimestamp = deprecatedFirstTimestamp;
    }

    public EventsV1Event deprecatedLastTimestamp(OffsetDateTime deprecatedLastTimestamp) {
        this.deprecatedLastTimestamp = deprecatedLastTimestamp;
        return this;
    }

    @Nullable
    public OffsetDateTime getDeprecatedLastTimestamp() {
        return this.deprecatedLastTimestamp;
    }

    public void setDeprecatedLastTimestamp(OffsetDateTime deprecatedLastTimestamp) {
        this.deprecatedLastTimestamp = deprecatedLastTimestamp;
    }

    public EventsV1Event deprecatedSource(V1EventSource deprecatedSource) {
        this.deprecatedSource = deprecatedSource;
        return this;
    }

    @Nullable
    public V1EventSource getDeprecatedSource() {
        return this.deprecatedSource;
    }

    public void setDeprecatedSource(V1EventSource deprecatedSource) {
        this.deprecatedSource = deprecatedSource;
    }

    public EventsV1Event eventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @Nonnull
    public OffsetDateTime getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
    }

    public EventsV1Event kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    @Nullable
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public EventsV1Event metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    @Nullable
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public EventsV1Event note(String note) {
        this.note = note;
        return this;
    }

    @Nullable
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public EventsV1Event reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public EventsV1Event regarding(V1ObjectReference regarding) {
        this.regarding = regarding;
        return this;
    }

    @Nullable
    public V1ObjectReference getRegarding() {
        return this.regarding;
    }

    public void setRegarding(V1ObjectReference regarding) {
        this.regarding = regarding;
    }

    public EventsV1Event related(V1ObjectReference related) {
        this.related = related;
        return this;
    }

    @Nullable
    public V1ObjectReference getRelated() {
        return this.related;
    }

    public void setRelated(V1ObjectReference related) {
        this.related = related;
    }

    public EventsV1Event reportingController(String reportingController) {
        this.reportingController = reportingController;
        return this;
    }

    @Nullable
    public String getReportingController() {
        return this.reportingController;
    }

    public void setReportingController(String reportingController) {
        this.reportingController = reportingController;
    }

    public EventsV1Event reportingInstance(String reportingInstance) {
        this.reportingInstance = reportingInstance;
        return this;
    }

    @Nullable
    public String getReportingInstance() {
        return this.reportingInstance;
    }

    public void setReportingInstance(String reportingInstance) {
        this.reportingInstance = reportingInstance;
    }

    public EventsV1Event series(EventsV1EventSeries series) {
        this.series = series;
        return this;
    }

    @Nullable
    public EventsV1EventSeries getSeries() {
        return this.series;
    }

    public void setSeries(EventsV1EventSeries series) {
        this.series = series;
    }

    public EventsV1Event type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventsV1Event eventsV1Event = (EventsV1Event)o;
        return Objects.equals(this.action, eventsV1Event.action) && Objects.equals(this.apiVersion, eventsV1Event.apiVersion) && Objects.equals(this.deprecatedCount, eventsV1Event.deprecatedCount) && Objects.equals(this.deprecatedFirstTimestamp, eventsV1Event.deprecatedFirstTimestamp) && Objects.equals(this.deprecatedLastTimestamp, eventsV1Event.deprecatedLastTimestamp) && Objects.equals(this.deprecatedSource, eventsV1Event.deprecatedSource) && Objects.equals(this.eventTime, eventsV1Event.eventTime) && Objects.equals(this.kind, eventsV1Event.kind) && Objects.equals(this.metadata, eventsV1Event.metadata) && Objects.equals(this.note, eventsV1Event.note) && Objects.equals(this.reason, eventsV1Event.reason) && Objects.equals(this.regarding, eventsV1Event.regarding) && Objects.equals(this.related, eventsV1Event.related) && Objects.equals(this.reportingController, eventsV1Event.reportingController) && Objects.equals(this.reportingInstance, eventsV1Event.reportingInstance) && Objects.equals(this.series, eventsV1Event.series) && Objects.equals(this.type, eventsV1Event.type);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.apiVersion, this.deprecatedCount, this.deprecatedFirstTimestamp, this.deprecatedLastTimestamp, this.deprecatedSource, this.eventTime, this.kind, this.metadata, this.note, this.reason, this.regarding, this.related, this.reportingController, this.reportingInstance, this.series, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventsV1Event {\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    deprecatedCount: ").append(this.toIndentedString(this.deprecatedCount)).append("\n");
        sb.append("    deprecatedFirstTimestamp: ").append(this.toIndentedString(this.deprecatedFirstTimestamp)).append("\n");
        sb.append("    deprecatedLastTimestamp: ").append(this.toIndentedString(this.deprecatedLastTimestamp)).append("\n");
        sb.append("    deprecatedSource: ").append(this.toIndentedString(this.deprecatedSource)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    regarding: ").append(this.toIndentedString(this.regarding)).append("\n");
        sb.append("    related: ").append(this.toIndentedString(this.related)).append("\n");
        sb.append("    reportingController: ").append(this.toIndentedString(this.reportingController)).append("\n");
        sb.append("    reportingInstance: ").append(this.toIndentedString(this.reportingInstance)).append("\n");
        sb.append("    series: ").append(this.toIndentedString(this.series)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in EventsV1Event is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `EventsV1Event` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ACTION) != null && !jsonObj.get(SERIALIZED_NAME_ACTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `action` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_API_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEPRECATED_SOURCE) != null && !jsonObj.get(SERIALIZED_NAME_DEPRECATED_SOURCE).isJsonNull()) {
            V1EventSource.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DEPRECATED_SOURCE));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_METADATA) != null && !jsonObj.get(SERIALIZED_NAME_METADATA).isJsonNull()) {
            V1ObjectMeta.validateJsonElement(jsonObj.get(SERIALIZED_NAME_METADATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_NOTE) != null && !jsonObj.get(SERIALIZED_NAME_NOTE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NOTE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `note` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NOTE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REASON) != null && !jsonObj.get(SERIALIZED_NAME_REASON).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REASON).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REASON).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REGARDING) != null && !jsonObj.get(SERIALIZED_NAME_REGARDING).isJsonNull()) {
            V1ObjectReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_REGARDING));
        }
        if (jsonObj.get(SERIALIZED_NAME_RELATED) != null && !jsonObj.get(SERIALIZED_NAME_RELATED).isJsonNull()) {
            V1ObjectReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RELATED));
        }
        if (jsonObj.get(SERIALIZED_NAME_REPORTING_CONTROLLER) != null && !jsonObj.get(SERIALIZED_NAME_REPORTING_CONTROLLER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REPORTING_CONTROLLER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reportingController` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REPORTING_CONTROLLER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REPORTING_INSTANCE) != null && !jsonObj.get(SERIALIZED_NAME_REPORTING_INSTANCE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REPORTING_INSTANCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reportingInstance` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REPORTING_INSTANCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SERIES) != null && !jsonObj.get(SERIALIZED_NAME_SERIES).isJsonNull()) {
            EventsV1EventSeries.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SERIES));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
    }

    public static EventsV1Event fromJson(String jsonString) throws IOException {
        return (EventsV1Event)JSON.getGson().fromJson(jsonString, EventsV1Event.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACTION);
        openapiFields.add(SERIALIZED_NAME_API_VERSION);
        openapiFields.add(SERIALIZED_NAME_DEPRECATED_COUNT);
        openapiFields.add(SERIALIZED_NAME_DEPRECATED_FIRST_TIMESTAMP);
        openapiFields.add(SERIALIZED_NAME_DEPRECATED_LAST_TIMESTAMP);
        openapiFields.add(SERIALIZED_NAME_DEPRECATED_SOURCE);
        openapiFields.add(SERIALIZED_NAME_EVENT_TIME);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_NOTE);
        openapiFields.add(SERIALIZED_NAME_REASON);
        openapiFields.add(SERIALIZED_NAME_REGARDING);
        openapiFields.add(SERIALIZED_NAME_RELATED);
        openapiFields.add(SERIALIZED_NAME_REPORTING_CONTROLLER);
        openapiFields.add(SERIALIZED_NAME_REPORTING_INSTANCE);
        openapiFields.add(SERIALIZED_NAME_SERIES);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_EVENT_TIME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!EventsV1Event.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(EventsV1Event.class));
            return new TypeAdapter<EventsV1Event>(){

                public void write(JsonWriter out, EventsV1Event value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public EventsV1Event read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    EventsV1Event.validateJsonElement(jsonElement);
                    return (EventsV1Event)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

