/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.utils;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.context.RequestContextHolder;
import com.alibaba.nacos.core.context.addition.AddressContext;
import com.alibaba.nacos.core.utils.WebUtils;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;

public class NamingRequestUtil {
    public static String getSourceIp() {
        AddressContext addressContext = RequestContextHolder.getContext().getBasicContext().getAddressContext();
        String sourceIp = addressContext.getSourceIp();
        if (StringUtils.isBlank((CharSequence)sourceIp)) {
            sourceIp = addressContext.getRemoteIp();
        }
        return sourceIp;
    }

    public static String getSourceIpForHttpRequest(HttpServletRequest httpServletRequest) {
        String sourceIp = NamingRequestUtil.getSourceIp();
        if (StringUtils.isBlank((CharSequence)sourceIp)) {
            sourceIp = WebUtils.getRemoteIp((HttpServletRequest)httpServletRequest);
        }
        return sourceIp;
    }

    public static String getSourceIpForGrpcRequest(RequestMeta meta) {
        String sourceIp = NamingRequestUtil.getSourceIp();
        if (StringUtils.isBlank((CharSequence)sourceIp)) {
            sourceIp = meta.getClientIp();
        }
        return sourceIp;
    }

    public static void checkWeight(Double weight) throws NacosException {
        if (weight > 10000.0 || weight < 0.0) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.WEIGHT_ERROR, "instance format invalid: The weights range from 0.0 to 10000.0");
        }
    }
}

