/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push.v2.task;

import com.alibaba.nacos.api.remote.PushCallBack;
import com.alibaba.nacos.common.task.BatchTaskCounter;
import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.push.v2.NoRequiredRetryException;
import com.alibaba.nacos.naming.push.v2.PushConfig;
import com.alibaba.nacos.naming.push.v2.task.FuzzyWatchPushDelayTaskEngine;
import com.alibaba.nacos.naming.push.v2.task.FuzzyWatchSyncNotifyTask;

class FuzzyWatchSyncNotifyCallback
implements PushCallBack {
    private FuzzyWatchSyncNotifyTask fuzzyWatchSyncNotifyTask;
    private BatchTaskCounter batchTaskCounter;
    private FuzzyWatchPushDelayTaskEngine fuzzyWatchPushDelayTaskEngine;

    FuzzyWatchSyncNotifyCallback(FuzzyWatchSyncNotifyTask fuzzyWatchSyncNotifyTask, BatchTaskCounter batchTaskCounter, FuzzyWatchPushDelayTaskEngine fuzzyWatchPushDelayTaskEngine) {
        this.batchTaskCounter = batchTaskCounter;
        this.fuzzyWatchPushDelayTaskEngine = fuzzyWatchPushDelayTaskEngine;
        this.fuzzyWatchSyncNotifyTask = fuzzyWatchSyncNotifyTask;
    }

    public long getTimeout() {
        return PushConfig.getInstance().getPushTaskTimeout();
    }

    public void onSuccess() {
        long now = System.currentTimeMillis();
        if (this.isFinishInitTask()) {
            Loggers.PUSH.info("[fuzzy watch] init notify finish push success  ,clientId={}, pattern ={},total cost time={}ms", new Object[]{this.fuzzyWatchSyncNotifyTask.getClientId(), this.fuzzyWatchSyncNotifyTask.getPattern(), now - this.fuzzyWatchSyncNotifyTask.getExecuteStartTime()});
        } else {
            Loggers.PUSH.info("[fuzzy watch] sync notify task success, pattern {}, syncType={},clientId={},current batch size {},currentBatch={},totalBatch={}", new Object[]{this.fuzzyWatchSyncNotifyTask.getPattern(), this.fuzzyWatchSyncNotifyTask.getSyncType(), this.fuzzyWatchSyncNotifyTask.getClientId(), this.fuzzyWatchSyncNotifyTask.getSyncServiceKeys().size(), this.fuzzyWatchSyncNotifyTask.getCurrentBatch()});
            if (this.isInitNotifyTask()) {
                Loggers.PUSH.info("[fuzzy watch] init notify push success  ,clientId={}, pattern ={} ,currentBatch={},totalBatch={}", new Object[]{this.fuzzyWatchSyncNotifyTask.getClientId(), this.fuzzyWatchSyncNotifyTask.getPattern(), this.fuzzyWatchSyncNotifyTask.getCurrentBatch(), this.fuzzyWatchSyncNotifyTask.getTotalBatch()});
                this.batchTaskCounter.batchSuccess(this.fuzzyWatchSyncNotifyTask.getCurrentBatch());
                if (this.batchTaskCounter.batchCompleted()) {
                    Loggers.PUSH.info("[fuzzy watch] init notify all batch finish ,clientId={}, pattern ={},start notify init finish task", (Object)this.fuzzyWatchSyncNotifyTask.getClientId(), (Object)this.fuzzyWatchSyncNotifyTask.getPattern());
                    FuzzyWatchSyncNotifyTask fuzzyWatchSyncNotifyTaskFinish = new FuzzyWatchSyncNotifyTask(this.fuzzyWatchSyncNotifyTask.getClientId(), this.fuzzyWatchSyncNotifyTask.getPattern(), "FINISH_FUZZY_WATCH_INIT_NOTIFY", null, PushConfig.getInstance().getPushTaskDelay());
                    this.fuzzyWatchPushDelayTaskEngine.addTask(FuzzyWatchPushDelayTaskEngine.getTaskKey((NacosTask)fuzzyWatchSyncNotifyTaskFinish), fuzzyWatchSyncNotifyTaskFinish);
                }
            }
        }
    }

    private boolean isFinishInitTask() {
        return "FINISH_FUZZY_WATCH_INIT_NOTIFY".equals(this.fuzzyWatchSyncNotifyTask.getSyncType());
    }

    private boolean isInitNotifyTask() {
        return "FUZZY_WATCH_INIT_NOTIFY".equals(this.fuzzyWatchSyncNotifyTask.getSyncType());
    }

    public void onFail(Throwable e) {
        Loggers.PUSH.warn("[fuzzy watch] sync notify fail, pattern {} ,clientId ={},currentBatch={},totalBatch={}", new Object[]{this.fuzzyWatchSyncNotifyTask.getPattern(), this.fuzzyWatchSyncNotifyTask.getClientId(), this.fuzzyWatchSyncNotifyTask.getCurrentBatch(), this.fuzzyWatchSyncNotifyTask.getTotalBatch(), e});
        if (!(e instanceof NoRequiredRetryException)) {
            Loggers.PUSH.warn("[fuzzy watch] reschedule this task to engine");
            this.fuzzyWatchPushDelayTaskEngine.addTask(FuzzyWatchPushDelayTaskEngine.getTaskKey((NacosTask)this.fuzzyWatchSyncNotifyTask), this.fuzzyWatchSyncNotifyTask);
        }
    }
}

