/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push;

import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.api.naming.pojo.maintainer.SubscriberInfo;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.naming.misc.HttpClient;
import com.alibaba.nacos.naming.pojo.Subscriber;
import com.alibaba.nacos.naming.push.NamingSubscriberService;
import com.alibaba.nacos.naming.push.NamingSubscriberServiceLocalImpl;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.springframework.stereotype.Service;

@Service
public class NamingSubscriberServiceAggregationImpl
implements NamingSubscriberService {
    private static final String SUBSCRIBER_ON_SYNC_URL = "/subscribers";
    private final NamingSubscriberServiceLocalImpl subscriberServiceLocal;
    private final ServerMemberManager memberManager;

    public NamingSubscriberServiceAggregationImpl(NamingSubscriberServiceLocalImpl subscriberServiceLocal, ServerMemberManager serverMemberManager) {
        this.subscriberServiceLocal = subscriberServiceLocal;
        this.memberManager = serverMemberManager;
    }

    @Override
    public Collection<Subscriber> getSubscribers(String namespaceId, String serviceName) {
        LinkedList<Subscriber> result = new LinkedList<Subscriber>(this.subscriberServiceLocal.getSubscribers(namespaceId, serviceName));
        if (this.memberManager.getServerList().size() > 1) {
            this.getSubscribersFromRemotes(namespaceId, serviceName, result);
        }
        return result;
    }

    @Override
    public Collection<Subscriber> getSubscribers(com.alibaba.nacos.naming.core.v2.pojo.Service service) {
        LinkedList<Subscriber> result = new LinkedList<Subscriber>(this.subscriberServiceLocal.getSubscribers(service));
        if (this.memberManager.getServerList().size() > 1) {
            this.getSubscribersFromRemotes(service.getNamespace(), service.getGroupedServiceName(), result);
        }
        return result;
    }

    @Override
    public Collection<Subscriber> getFuzzySubscribers(String namespaceId, String serviceName) {
        LinkedList<Subscriber> result = new LinkedList<Subscriber>(this.subscriberServiceLocal.getFuzzySubscribers(namespaceId, serviceName));
        if (this.memberManager.getServerList().size() > 1) {
            this.getSubscribersFromRemotes(namespaceId, serviceName, result);
        }
        return result;
    }

    @Override
    public Collection<Subscriber> getFuzzySubscribers(com.alibaba.nacos.naming.core.v2.pojo.Service service) {
        LinkedList<Subscriber> result = new LinkedList<Subscriber>(this.subscriberServiceLocal.getFuzzySubscribers(service));
        if (this.memberManager.getServerList().size() > 1) {
            this.getSubscribersFromRemotes(service.getNamespace(), service.getGroupedServiceName(), result);
        }
        return result;
    }

    private void getSubscribersFromRemotes(String namespaceId, String serviceName, Collection<Subscriber> result) {
        for (Member server : this.memberManager.allMembersWithoutSelf()) {
            HashMap<String, String> paramValues = new HashMap<String, String>(128);
            String groupName = NamingUtils.getGroupName((String)serviceName);
            String serviceNameWithoutGroup = NamingUtils.getServiceName((String)serviceName);
            paramValues.put("groupName", groupName);
            paramValues.put("serviceName", serviceNameWithoutGroup);
            paramValues.put("namespaceId", namespaceId);
            paramValues.put("aggregation", String.valueOf(Boolean.FALSE));
            RestResult<String> response = HttpClient.httpGet("http://" + server.getAddress() + EnvUtil.getContextPath() + "/v3/admin/ns/service/subscribers", new ArrayList<String>(), paramValues);
            if (!response.ok()) continue;
            Result subscribers = (Result)JacksonUtils.toObj((String)((String)response.getData()), (TypeReference)new TypeReference<Result<Page<SubscriberInfo>>>(){});
            for (SubscriberInfo each : ((Page)subscribers.getData()).getPageItems()) {
                result.add(new Subscriber(each.getAddress(), each.getAgent(), each.getAppName(), each.getIp(), each.getNamespaceId(), serviceName, each.getPort()));
            }
        }
    }
}

