/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers.v3;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.trace.DeregisterInstanceReason;
import com.alibaba.nacos.common.trace.event.naming.DeregisterInstanceTraceEvent;
import com.alibaba.nacos.common.trace.event.naming.RegisterInstanceTraceEvent;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.naming.core.InstanceOperator;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.model.form.InstanceForm;
import com.alibaba.nacos.naming.model.form.InstanceListForm;
import com.alibaba.nacos.naming.paramcheck.NamingDefaultHttpParamExtractor;
import com.alibaba.nacos.naming.paramcheck.NamingInstanceListHttpParamExtractor;
import com.alibaba.nacos.naming.pojo.instance.BeatInfoInstanceBuilder;
import com.alibaba.nacos.naming.utils.InstanceUtil;
import com.alibaba.nacos.naming.utils.NamingRequestUtil;
import com.alibaba.nacos.naming.web.CanDistro;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v3/client/ns/instance"})
@ExtractorManager.Extractor(httpExtractor=NamingDefaultHttpParamExtractor.class)
public class InstanceOpenApiController {
    private final InstanceOperator instanceOperator;
    private final SwitchDomain switchDomain;

    public InstanceOpenApiController(InstanceOperator instanceOperator, SwitchDomain switchDomain) {
        this.instanceOperator = instanceOperator;
        this.switchDomain = switchDomain;
    }

    @CanDistro
    @PostMapping
    @TpsControl(pointName="NamingInstanceRegister", name="HttpNamingInstanceRegister")
    @Secured(action=ActionTypes.WRITE, apiType=ApiType.OPEN_API)
    public Result<String> register(InstanceForm instanceForm, @RequestParam(defaultValue="false") boolean heartBeat) throws NacosException {
        instanceForm.validate();
        if (heartBeat) {
            if (10200 != this.doHeartBeat(instanceForm)) {
                return Result.failure((ErrorCode)ErrorCode.INSTANCE_NOT_FOUND, null);
            }
        } else {
            this.doRegisterInstance(instanceForm);
        }
        return Result.success((Object)"ok");
    }

    @CanDistro
    @DeleteMapping
    @TpsControl(pointName="NamingInstanceDeregister", name="HttpNamingInstanceDeregister")
    @Secured(action=ActionTypes.WRITE, apiType=ApiType.OPEN_API)
    public Result<String> deregister(InstanceForm instanceForm) throws NacosException {
        instanceForm.validate();
        Instance instance = InstanceUtil.buildInstance(instanceForm, this.switchDomain.isDefaultInstanceEphemeral());
        this.instanceOperator.removeInstance(instanceForm.getNamespaceId(), instanceForm.getGroupName(), instanceForm.getServiceName(), instance);
        NotifyCenter.publishEvent((Event)new DeregisterInstanceTraceEvent(System.currentTimeMillis(), NamingRequestUtil.getSourceIp(), false, DeregisterInstanceReason.REQUEST, instanceForm.getNamespaceId(), instanceForm.getGroupName(), instanceForm.getServiceName(), instance.getIp(), instance.getPort()));
        return Result.success((Object)"ok");
    }

    @GetMapping(value={"/list"})
    @TpsControl(pointName="NamingServiceSubscribe", name="HttpNamingServiceSubscribe")
    @Secured(action=ActionTypes.READ, apiType=ApiType.OPEN_API)
    @ExtractorManager.Extractor(httpExtractor=NamingInstanceListHttpParamExtractor.class)
    public Result<List<Instance>> list(InstanceListForm instanceForm) throws Exception {
        instanceForm.validate();
        String namespaceId = instanceForm.getNamespaceId();
        String groupName = instanceForm.getGroupName();
        String serviceName = instanceForm.getServiceName();
        ServiceInfo serviceInfo = this.instanceOperator.listInstance(namespaceId, groupName, serviceName, null, instanceForm.getClusterName(), false);
        return Result.success((Object)serviceInfo.getHosts());
    }

    private int doHeartBeat(InstanceForm instanceForm) throws NacosException {
        BeatInfoInstanceBuilder builder = BeatInfoInstanceBuilder.newBuilder();
        return this.instanceOperator.handleBeat(instanceForm.getNamespaceId(), instanceForm.getGroupName(), instanceForm.getServiceName(), instanceForm.getIp(), instanceForm.getPort(), instanceForm.getClusterName(), null, builder);
    }

    private void doRegisterInstance(InstanceForm instanceForm) throws NacosException {
        NamingRequestUtil.checkWeight(instanceForm.getWeight());
        Instance instance = InstanceUtil.buildInstance(instanceForm, this.switchDomain.isDefaultInstanceEphemeral());
        String namespaceId = instanceForm.getNamespaceId();
        String groupName = instanceForm.getGroupName();
        String serviceName = instanceForm.getServiceName();
        this.instanceOperator.registerInstance(namespaceId, groupName, serviceName, instance);
        NotifyCenter.publishEvent((Event)new RegisterInstanceTraceEvent(System.currentTimeMillis(), NamingRequestUtil.getSourceIp(), false, namespaceId, groupName, serviceName, instance.getIp(), instance.getPort()));
    }
}

