/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers.v3;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.api.naming.pojo.healthcheck.AbstractHealthChecker;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.naming.core.HealthOperatorV2Impl;
import com.alibaba.nacos.naming.model.form.UpdateHealthForm;
import com.alibaba.nacos.naming.paramcheck.NamingDefaultHttpParamExtractor;
import com.alibaba.nacos.naming.web.CanDistro;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v3/admin/ns/health"})
@ExtractorManager.Extractor(httpExtractor=NamingDefaultHttpParamExtractor.class)
public class HealthControllerV3 {
    @Autowired
    private HealthOperatorV2Impl healthOperatorV2;

    @CanDistro
    @PutMapping(value={"/instance"})
    @Secured(action=ActionTypes.WRITE, apiType=ApiType.ADMIN_API)
    public Result<String> update(UpdateHealthForm updateHealthForm) throws NacosException {
        updateHealthForm.validate();
        this.healthOperatorV2.updateHealthStatusForPersistentInstance(updateHealthForm.getNamespaceId(), updateHealthForm.getGroupName(), updateHealthForm.getServiceName(), updateHealthForm.getClusterName(), updateHealthForm.getIp(), updateHealthForm.getPort(), updateHealthForm.getHealthy());
        return Result.success((Object)"ok");
    }

    @GetMapping(value={"/checkers"})
    @Secured(action=ActionTypes.WRITE, apiType=ApiType.ADMIN_API)
    public Result<Map<String, AbstractHealthChecker>> checkers() {
        return Result.success(this.healthOperatorV2.checkers());
    }
}

