/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers.v2;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.pojo.builder.InstanceBuilder;
import com.alibaba.nacos.api.naming.pojo.maintainer.InstanceMetadataBatchResult;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.trace.DeregisterInstanceReason;
import com.alibaba.nacos.common.trace.event.naming.DeregisterInstanceTraceEvent;
import com.alibaba.nacos.common.trace.event.naming.RegisterInstanceTraceEvent;
import com.alibaba.nacos.common.trace.event.naming.UpdateInstanceTraceEvent;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.controller.compatibility.Compatibility;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.naming.core.InstanceOperatorClientImpl;
import com.alibaba.nacos.naming.core.InstancePatchObject;
import com.alibaba.nacos.naming.healthcheck.RsInfo;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import com.alibaba.nacos.naming.model.form.InstanceForm;
import com.alibaba.nacos.naming.model.form.InstanceMetadataBatchOperationForm;
import com.alibaba.nacos.naming.model.vo.InstanceDetailInfoVo;
import com.alibaba.nacos.naming.paramcheck.NamingDefaultHttpParamExtractor;
import com.alibaba.nacos.naming.paramcheck.NamingInstanceBeatHttpParamExtractor;
import com.alibaba.nacos.naming.paramcheck.NamingInstanceListHttpParamExtractor;
import com.alibaba.nacos.naming.paramcheck.NamingInstanceMetadataBatchHttpParamExtractor;
import com.alibaba.nacos.naming.pojo.InstanceOperationInfo;
import com.alibaba.nacos.naming.pojo.Subscriber;
import com.alibaba.nacos.naming.pojo.instance.BeatInfoInstanceBuilder;
import com.alibaba.nacos.naming.utils.NamingRequestUtil;
import com.alibaba.nacos.naming.web.CanDistro;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Deprecated
@NacosApi
@RestController
@RequestMapping(value={"/v2/ns/instance"})
@ExtractorManager.Extractor(httpExtractor=NamingDefaultHttpParamExtractor.class)
public class InstanceControllerV2 {
    @Autowired
    private SwitchDomain switchDomain;
    @Autowired
    private InstanceOperatorClientImpl instanceServiceV2;

    @CanDistro
    @PostMapping
    @TpsControl(pointName="NamingInstanceRegister", name="HttpNamingInstanceRegister")
    @Secured(action=ActionTypes.WRITE)
    @Compatibility(apiType=ApiType.ADMIN_API, alternatives="POST ${contextPath:nacos}/v3/admin/ns/instance")
    public Result<String> register(InstanceForm instanceForm) throws NacosException {
        instanceForm.validate();
        this.checkWeight(instanceForm.getWeight());
        Instance instance = this.buildInstance(instanceForm);
        this.instanceServiceV2.registerInstance(instanceForm.getNamespaceId(), this.buildCompositeServiceName(instanceForm), instance);
        NotifyCenter.publishEvent((Event)new RegisterInstanceTraceEvent(System.currentTimeMillis(), NamingRequestUtil.getSourceIp(), false, instanceForm.getNamespaceId(), instanceForm.getGroupName(), instanceForm.getServiceName(), instance.getIp(), instance.getPort()));
        return Result.success((Object)"ok");
    }

    @CanDistro
    @DeleteMapping
    @TpsControl(pointName="NamingInstanceDeregister", name="HttpNamingInstanceDeregister")
    @Secured(action=ActionTypes.WRITE)
    @Compatibility(apiType=ApiType.ADMIN_API, alternatives="DELETE ${contextPath:nacos}/v3/admin/ns/instance")
    public Result<String> deregister(InstanceForm instanceForm) throws NacosException {
        instanceForm.validate();
        this.checkWeight(instanceForm.getWeight());
        Instance instance = this.buildInstance(instanceForm);
        this.instanceServiceV2.removeInstance(instanceForm.getNamespaceId(), this.buildCompositeServiceName(instanceForm), instance);
        NotifyCenter.publishEvent((Event)new DeregisterInstanceTraceEvent(System.currentTimeMillis(), NamingRequestUtil.getSourceIp(), false, DeregisterInstanceReason.REQUEST, instanceForm.getNamespaceId(), instanceForm.getGroupName(), instanceForm.getServiceName(), instance.getIp(), instance.getPort()));
        return Result.success((Object)"ok");
    }

    @CanDistro
    @PutMapping
    @TpsControl(pointName="NamingInstanceUpdate", name="HttpNamingInstanceUpdate")
    @Secured(action=ActionTypes.WRITE)
    @Compatibility(apiType=ApiType.ADMIN_API, alternatives="PUT ${contextPath:nacos}/v3/admin/ns/instance")
    public Result<String> update(InstanceForm instanceForm) throws NacosException {
        instanceForm.validate();
        this.checkWeight(instanceForm.getWeight());
        Instance instance = this.buildInstance(instanceForm);
        this.instanceServiceV2.updateInstance(instanceForm.getNamespaceId(), this.buildCompositeServiceName(instanceForm), instance);
        NotifyCenter.publishEvent((Event)new UpdateInstanceTraceEvent(System.currentTimeMillis(), NamingRequestUtil.getSourceIp(), instanceForm.getNamespaceId(), instanceForm.getGroupName(), instanceForm.getServiceName(), instance.getIp(), instance.getPort(), instance.getMetadata()));
        return Result.success((Object)"ok");
    }

    @CanDistro
    @PutMapping(value={"/metadata/batch"})
    @TpsControl(pointName="NamingInstanceMetadataUpdate", name="HttpNamingInstanceMetadataBatchUpdate")
    @Secured(action=ActionTypes.WRITE)
    @ExtractorManager.Extractor(httpExtractor=NamingInstanceMetadataBatchHttpParamExtractor.class)
    @Compatibility(apiType=ApiType.ADMIN_API, alternatives="PUT ${contextPath:nacos}/v3/admin/ns/instance/metadata/batch")
    public Result<InstanceMetadataBatchResult> batchUpdateInstanceMetadata(InstanceMetadataBatchOperationForm form) throws NacosException {
        form.validate();
        List<Instance> targetInstances = this.parseBatchInstances(form.getInstances());
        Map<String, String> targetMetadata = UtilsAndCommons.parseMetadata(form.getMetadata());
        InstanceOperationInfo instanceOperationInfo = this.buildOperationInfo(this.buildCompositeServiceName(form), form.getConsistencyType(), targetInstances);
        List<String> operatedInstances = this.instanceServiceV2.batchUpdateMetadata(form.getNamespaceId(), instanceOperationInfo, targetMetadata);
        ArrayList<String> ipList = new ArrayList<String>(operatedInstances);
        return Result.success((Object)new InstanceMetadataBatchResult(ipList));
    }

    @CanDistro
    @DeleteMapping(value={"/metadata/batch"})
    @TpsControl(pointName="NamingInstanceMetadataUpdate", name="HttpNamingInstanceMetadataBatchUpdate")
    @Secured(action=ActionTypes.WRITE)
    @ExtractorManager.Extractor(httpExtractor=NamingInstanceMetadataBatchHttpParamExtractor.class)
    @Compatibility(apiType=ApiType.ADMIN_API, alternatives="DELETE ${contextPath:nacos}/v3/admin/ns/instance/metadata/batch")
    public Result<InstanceMetadataBatchResult> batchDeleteInstanceMetadata(InstanceMetadataBatchOperationForm form) throws NacosException {
        form.validate();
        List<Instance> targetInstances = this.parseBatchInstances(form.getInstances());
        Map<String, String> targetMetadata = UtilsAndCommons.parseMetadata(form.getMetadata());
        InstanceOperationInfo instanceOperationInfo = this.buildOperationInfo(this.buildCompositeServiceName(form), form.getConsistencyType(), targetInstances);
        List<String> operatedInstances = this.instanceServiceV2.batchDeleteMetadata(form.getNamespaceId(), instanceOperationInfo, targetMetadata);
        ArrayList<String> ipList = new ArrayList<String>(operatedInstances);
        return Result.success((Object)new InstanceMetadataBatchResult(ipList));
    }

    private InstanceOperationInfo buildOperationInfo(String serviceName, String consistencyType, List<Instance> instances) {
        if (!CollectionUtils.isEmpty(instances)) {
            for (Instance instance : instances) {
                if (!StringUtils.isBlank((CharSequence)instance.getClusterName())) continue;
                instance.setClusterName("DEFAULT");
            }
        }
        return new InstanceOperationInfo(serviceName, consistencyType, instances);
    }

    private List<Instance> parseBatchInstances(String instances) {
        try {
            return (List)JacksonUtils.toObj((String)instances, (TypeReference)new TypeReference<List<Instance>>(){});
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("UPDATE-METADATA: Param 'instances' is illegal, ignore this operation", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @CanDistro
    @PatchMapping
    @Secured(action=ActionTypes.WRITE)
    @Compatibility(apiType=ApiType.ADMIN_API, alternatives="PUT ${contextPath:nacos}/v3/admin/ns/instance/partial")
    public String patch(@RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName, @RequestParam String ip, @RequestParam(defaultValue="DEFAULT") String cluster, @RequestParam Integer port, @RequestParam Double weight, @RequestParam Boolean enabled, @RequestParam String metadata) throws Exception {
        NamingUtils.checkServiceNameFormat((String)serviceName);
        InstancePatchObject patchObject = new InstancePatchObject(cluster, ip, port);
        if (StringUtils.isNotBlank((String)metadata)) {
            patchObject.setMetadata(UtilsAndCommons.parseMetadata(metadata));
        }
        if (weight != null) {
            this.checkWeight(weight);
            patchObject.setWeight(weight);
        }
        if (enabled != null) {
            patchObject.setEnabled(enabled);
        }
        this.instanceServiceV2.patchInstance(namespaceId, serviceName, patchObject);
        return "ok";
    }

    @GetMapping(value={"/list"})
    @TpsControl(pointName="NamingServiceSubscribe", name="HttpNamingServiceSubscribe")
    @Secured(action=ActionTypes.READ)
    @ExtractorManager.Extractor(httpExtractor=NamingInstanceListHttpParamExtractor.class)
    @Compatibility(apiType=ApiType.ADMIN_API, alternatives="GET ${contextPath:nacos}/v3/admin/ns/instance/list")
    public Result<ServiceInfo> list(@RequestParam(value="namespaceId", defaultValue="public") String namespaceId, @RequestParam(value="groupName", defaultValue="DEFAULT_GROUP") String groupName, @RequestParam(value="serviceName") String serviceName, @RequestParam(value="clusterName", defaultValue="") String clusterName, @RequestParam(value="ip", defaultValue="") String ip, @RequestParam(value="port", defaultValue="0") Integer port, @RequestParam(value="healthyOnly", defaultValue="false") Boolean healthyOnly, @RequestParam(value="app", defaultValue="") String app, @RequestHeader(value="User-Agent", required=false) String userAgent, @RequestHeader(value="Client-Version", required=false) String clientVersion) throws Exception {
        if (StringUtils.isEmpty((String)userAgent)) {
            userAgent = StringUtils.defaultIfEmpty((String)clientVersion, (String)"");
        }
        String compositeServiceName = NamingUtils.getGroupedName((String)serviceName, (String)groupName);
        Subscriber subscriber = new Subscriber(ip + ":" + port, userAgent, app, ip, namespaceId, compositeServiceName, port, clusterName);
        return Result.success((Object)this.instanceServiceV2.listInstance(namespaceId, compositeServiceName, subscriber, clusterName, healthyOnly));
    }

    @GetMapping
    @TpsControl(pointName="NamingInstanceQuery", name="HttpNamingInstanceQuery")
    @Secured(action=ActionTypes.READ)
    @Compatibility(apiType=ApiType.ADMIN_API, alternatives="GET ${contextPath:nacos}/v3/admin/ns/instance")
    public Result<InstanceDetailInfoVo> detail(@RequestParam(value="namespaceId", defaultValue="public") String namespaceId, @RequestParam(value="groupName", defaultValue="DEFAULT_GROUP") String groupName, @RequestParam(value="serviceName") String serviceName, @RequestParam(value="clusterName", defaultValue="DEFAULT") String clusterName, @RequestParam(value="ip") String ip, @RequestParam(value="port") Integer port) throws NacosException {
        String compositeServiceName = NamingUtils.getGroupedName((String)serviceName, (String)groupName);
        Instance instance = this.instanceServiceV2.getInstance(namespaceId, compositeServiceName, clusterName, ip, port);
        InstanceDetailInfoVo instanceDetailInfoVo = new InstanceDetailInfoVo();
        instanceDetailInfoVo.setServiceName(compositeServiceName);
        instanceDetailInfoVo.setIp(ip);
        instanceDetailInfoVo.setPort(port);
        instanceDetailInfoVo.setClusterName(clusterName);
        instanceDetailInfoVo.setWeight(instance.getWeight());
        instanceDetailInfoVo.setHealthy(instance.isHealthy());
        instanceDetailInfoVo.setInstanceId(instance.getInstanceId());
        instanceDetailInfoVo.setMetadata(instance.getMetadata());
        return Result.success((Object)instanceDetailInfoVo);
    }

    @CanDistro
    @PutMapping(value={"/beat"})
    @TpsControl(pointName="HttpHealthCheck", name="HttpHealthCheck")
    @Secured(action=ActionTypes.WRITE)
    @ExtractorManager.Extractor(httpExtractor=NamingInstanceBeatHttpParamExtractor.class)
    @Compatibility(apiType=ApiType.ADMIN_API)
    public ObjectNode beat(@RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName, @RequestParam(defaultValue="") String ip, @RequestParam(defaultValue="DEFAULT") String clusterName, @RequestParam(defaultValue="0") Integer port, @RequestParam(defaultValue="") String beat) throws Exception {
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        result.put("clientBeatInterval", this.switchDomain.getClientBeatInterval());
        RsInfo clientBeat = null;
        if (StringUtils.isNotBlank((String)beat)) {
            clientBeat = (RsInfo)JacksonUtils.toObj((String)beat, RsInfo.class);
        }
        if (clientBeat != null) {
            if (StringUtils.isNotBlank((String)clientBeat.getCluster())) {
                clusterName = clientBeat.getCluster();
            } else {
                clientBeat.setCluster(clusterName);
            }
            ip = clientBeat.getIp();
            port = clientBeat.getPort();
        }
        NamingUtils.checkServiceNameFormat((String)serviceName);
        Loggers.SRV_LOG.debug("[CLIENT-BEAT] full arguments: beat: {}, serviceName: {}, namespaceId: {}", new Object[]{clientBeat, serviceName, namespaceId});
        BeatInfoInstanceBuilder builder = BeatInfoInstanceBuilder.newBuilder();
        int resultCode = this.instanceServiceV2.handleBeat(namespaceId, serviceName, ip, port, clusterName, clientBeat, builder);
        result.put("code", resultCode);
        result.put("clientBeatInterval", this.instanceServiceV2.getHeartBeatInterval(namespaceId, serviceName, ip, port, clusterName));
        result.put("lightBeatEnabled", this.switchDomain.isLightBeatEnabled());
        return result;
    }

    @RequestMapping(value={"/statuses/{key}"})
    @Compatibility(apiType=ApiType.ADMIN_API)
    public ObjectNode listWithHealthStatus(@PathVariable String key) throws NacosException {
        String serviceName;
        String namespaceId;
        if (key.contains("##")) {
            namespaceId = key.split("##")[0];
            serviceName = key.split("##")[1];
        } else {
            namespaceId = "public";
            serviceName = key;
        }
        NamingUtils.checkServiceNameFormat((String)serviceName);
        List<? extends Instance> ips = this.instanceServiceV2.listAllInstances(namespaceId, serviceName);
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        ArrayNode ipArray = JacksonUtils.createEmptyArrayNode();
        for (Instance instance : ips) {
            ipArray.add(instance.toInetAddr() + "_" + instance.isHealthy());
        }
        result.replace("ips", (JsonNode)ipArray);
        return result;
    }

    private void checkWeight(Double weight) throws NacosException {
        if (weight > 10000.0 || weight < 0.0) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.WEIGHT_ERROR, "instance format invalid: The weights range from 0.0 to 10000.0");
        }
    }

    private Instance buildInstance(InstanceForm instanceForm) throws NacosException {
        Instance instance = InstanceBuilder.newBuilder().setServiceName(this.buildCompositeServiceName(instanceForm)).setIp(instanceForm.getIp()).setClusterName(instanceForm.getClusterName()).setPort(instanceForm.getPort()).setHealthy(instanceForm.getHealthy()).setWeight(instanceForm.getWeight()).setEnabled(instanceForm.getEnabled()).setMetadata(UtilsAndCommons.parseMetadata(instanceForm.getMetadata())).setEphemeral(instanceForm.getEphemeral()).build();
        if (instanceForm.getEphemeral() == null) {
            instance.setEphemeral(this.switchDomain.isDefaultInstanceEphemeral());
        }
        return instance;
    }

    private String buildCompositeServiceName(InstanceForm instanceForm) {
        return NamingUtils.getGroupedName((String)instanceForm.getServiceName(), (String)instanceForm.getGroupName());
    }

    private String buildCompositeServiceName(InstanceMetadataBatchOperationForm form) {
        return NamingUtils.getGroupedName((String)form.getServiceName(), (String)form.getGroupName());
    }
}

