/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.lock.service.impl;

import com.alibaba.nacos.api.lock.model.LockInstance;
import com.alibaba.nacos.api.lock.remote.LockOperationEnum;
import com.alibaba.nacos.consistency.SerializeFactory;
import com.alibaba.nacos.consistency.Serializer;
import com.alibaba.nacos.consistency.cp.CPProtocol;
import com.alibaba.nacos.consistency.cp.RequestProcessor4CP;
import com.alibaba.nacos.consistency.entity.ReadRequest;
import com.alibaba.nacos.consistency.entity.Response;
import com.alibaba.nacos.consistency.entity.WriteRequest;
import com.alibaba.nacos.consistency.snapshot.SnapshotOperation;
import com.alibaba.nacos.core.distributed.ProtocolManager;
import com.alibaba.nacos.lock.LockManager;
import com.alibaba.nacos.lock.constant.PropertiesConstant;
import com.alibaba.nacos.lock.core.reentrant.AtomicLockService;
import com.alibaba.nacos.lock.exception.NacosLockException;
import com.alibaba.nacos.lock.model.LockInfo;
import com.alibaba.nacos.lock.model.LockKey;
import com.alibaba.nacos.lock.persistence.NacosLockSnapshotOperation;
import com.alibaba.nacos.lock.raft.request.MutexLockRequest;
import com.alibaba.nacos.lock.service.LockOperationService;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import com.google.protobuf.ByteString;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LockOperationServiceImpl
extends RequestProcessor4CP
implements LockOperationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockOperationServiceImpl.class);
    private final Serializer serializer = SerializeFactory.getDefault();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final CPProtocol protocol;
    private final LockManager lockManager;
    private final long defaultExpireTime;
    private final long maxExpireTime;

    public LockOperationServiceImpl(LockManager lockManager) {
        this.lockManager = lockManager;
        this.protocol = ((ProtocolManager)ApplicationUtils.getBean(ProtocolManager.class)).getCpProtocol();
        this.protocol.addRequestProcessors(Collections.singletonList(this));
        this.defaultExpireTime = (Long)EnvUtil.getProperty((String)"nacos.lock.default_expire_time", Long.class, (Object)PropertiesConstant.DEFAULT_AUTO_EXPIRE_TIME);
        this.maxExpireTime = (Long)EnvUtil.getProperty((String)"nacos.lock.max_expire_time", Long.class, (Object)PropertiesConstant.MAX_AUTO_EXPIRE_TIME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response onApply(WriteRequest request) {
        ReentrantReadWriteLock.ReadLock lock = this.readLock;
        lock.lock();
        try {
            LockOperationEnum lockOperation = LockOperationEnum.valueOf((String)request.getOperation());
            Boolean data = null;
            if (lockOperation == LockOperationEnum.ACQUIRE) {
                mutexLockRequest = (MutexLockRequest)this.serializer.deserialize(request.getData().toByteArray());
                data = this.acquireLock(mutexLockRequest);
            } else if (lockOperation == LockOperationEnum.RELEASE) {
                mutexLockRequest = (MutexLockRequest)this.serializer.deserialize(request.getData().toByteArray());
                data = this.releaseLock(mutexLockRequest);
            } else {
                throw new NacosLockException("lockOperation is not exist.");
            }
            LOGGER.info("thread: {}, operator: {}, request: {}, success: {}", new Object[]{Thread.currentThread().getName(), lockOperation, this.serializer.deserialize(request.getData().toByteArray()), data});
            ByteString bytes = ByteString.copyFrom((byte[])this.serializer.serialize((Object)data));
            Response response = Response.newBuilder().setSuccess(true).setData(bytes).build();
            return response;
        }
        catch (NacosLockException e) {
            Response response = Response.newBuilder().setSuccess(false).setErrMsg(e.getMessage()).build();
            return response;
        }
        finally {
            lock.unlock();
        }
    }

    private Boolean releaseLock(MutexLockRequest request) {
        LockInfo lockInfo = request.getLockInfo();
        AtomicLockService mutexLock = this.lockManager.getMutexLock(lockInfo.getKey());
        Boolean unLock = mutexLock.unLock(lockInfo);
        if (mutexLock.isClear().booleanValue()) {
            this.lockManager.removeMutexLock(lockInfo.getKey());
        }
        return unLock;
    }

    private Boolean acquireLock(MutexLockRequest request) {
        LockInfo lockInfo = request.getLockInfo();
        AtomicLockService mutexLock = this.lockManager.getMutexLock(lockInfo.getKey());
        return mutexLock.tryLock(lockInfo);
    }

    @Override
    public Boolean lock(LockInstance lockInstance) {
        MutexLockRequest request = new MutexLockRequest();
        LockInfo lockInfo = new LockInfo();
        lockInfo.setKey(new LockKey(lockInstance.getLockType(), lockInstance.getKey()));
        lockInfo.setParams(lockInstance.getParams());
        long expiredTime = lockInstance.getExpiredTime();
        if (expiredTime < 0L) {
            lockInfo.setEndTime(this.defaultExpireTime + this.getNowTimestamp());
        } else {
            lockInfo.setEndTime(Math.min(this.maxExpireTime, expiredTime) + this.getNowTimestamp());
        }
        request.setLockInfo(lockInfo);
        WriteRequest writeRequest = WriteRequest.newBuilder().setGroup(this.group()).setData(ByteString.copyFrom((byte[])this.serializer.serialize((Object)request))).setOperation(LockOperationEnum.ACQUIRE.name()).build();
        try {
            Response response = this.protocol.write(writeRequest);
            if (response.getSuccess()) {
                return (Boolean)this.serializer.deserialize(response.getData().toByteArray());
            }
            throw new NacosLockException(response.getErrMsg());
        }
        catch (NacosLockException e) {
            int paramSize = lockInstance.getParams() == null ? 0 : lockInstance.getParams().size();
            LOGGER.error("key: {}, lockType:{}, paramSize:{} lock fail, errorMsg: {}", new Object[]{lockInstance.getKey(), lockInstance.getLockType(), paramSize, e.getMessage()});
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("lock fail.", (Throwable)e);
            throw new NacosLockException("tryLock error.", e);
        }
    }

    public List<SnapshotOperation> loadSnapshotOperate() {
        return Collections.singletonList(new NacosLockSnapshotOperation(this.lockManager, this.lock.writeLock()));
    }

    @Override
    public Boolean unLock(LockInstance lockInstance) {
        MutexLockRequest request = new MutexLockRequest();
        LockInfo lockInfo = new LockInfo();
        lockInfo.setKey(new LockKey(lockInstance.getLockType(), lockInstance.getKey()));
        lockInfo.setParams(lockInstance.getParams());
        request.setLockInfo(lockInfo);
        WriteRequest writeRequest = WriteRequest.newBuilder().setGroup(this.group()).setData(ByteString.copyFrom((byte[])this.serializer.serialize((Object)request))).setOperation(LockOperationEnum.RELEASE.name()).build();
        try {
            Response response = this.protocol.write(writeRequest);
            if (response.getSuccess()) {
                return (Boolean)this.serializer.deserialize(response.getData().toByteArray());
            }
            throw new NacosLockException(response.getErrMsg());
        }
        catch (NacosLockException e) {
            int paramSize = lockInstance.getParams() == null ? 0 : lockInstance.getParams().size();
            LOGGER.error("key: {}, lockType:{}, paramSize:{} lock fail, errorMsg: {}", new Object[]{lockInstance.getKey(), lockInstance.getLockType(), paramSize, e.getMessage()});
            throw e;
        }
        catch (Exception e) {
            throw new NacosLockException("unLock error.", e);
        }
    }

    public long getNowTimestamp() {
        return System.currentTimeMillis();
    }

    public Response onRequest(ReadRequest request) {
        return null;
    }

    public String group() {
        return "lock_acquire_service_v2";
    }
}

