/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.lock.monitor;

import com.alibaba.nacos.api.lock.remote.LockOperationEnum;
import com.alibaba.nacos.core.monitor.NacosMeterRegistryCenter;
import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class LockMetricsMonitor {
    private static final String METER_REGISTRY = "LOCK_STABLE_REGISTRY";
    private static AtomicInteger grpcLockSuccess = new AtomicInteger();
    private static AtomicInteger grpcUnLockSuccess = new AtomicInteger();
    private static AtomicInteger grpcLockTotal = new AtomicInteger();
    private static AtomicInteger grpcUnLockTotal = new AtomicInteger();
    private static AtomicInteger aliveLockCount = new AtomicInteger();

    public static AtomicInteger getGrpcLockSuccess() {
        return grpcLockSuccess;
    }

    public static AtomicInteger getGrpcUnLockSuccess() {
        return grpcUnLockSuccess;
    }

    public static AtomicInteger getGrpcLockTotal() {
        return grpcLockTotal;
    }

    public static AtomicInteger getGrpcUnLockTotal() {
        return grpcUnLockTotal;
    }

    public static Timer getLockHandlerTimer() {
        return NacosMeterRegistryCenter.timer((String)METER_REGISTRY, (String)"nacos_timer", (String[])new String[]{"module", "lock", "name", "lockHandlerRt"});
    }

    public static AtomicInteger getSuccessMeter(LockOperationEnum lockOperationEnum) {
        if (lockOperationEnum == LockOperationEnum.ACQUIRE) {
            return grpcLockSuccess;
        }
        return grpcUnLockSuccess;
    }

    public static AtomicInteger getTotalMeter(LockOperationEnum lockOperationEnum) {
        if (lockOperationEnum == LockOperationEnum.ACQUIRE) {
            return grpcLockTotal;
        }
        return grpcUnLockTotal;
    }

    static {
        ImmutableTag immutableTag = new ImmutableTag("module", "lock");
        ArrayList<ImmutableTag> tags = new ArrayList<ImmutableTag>();
        tags.add(immutableTag);
        tags.add(new ImmutableTag("name", "grpcLockTotal"));
        NacosMeterRegistryCenter.gauge((String)METER_REGISTRY, (String)"nacos_monitor", tags, (Number)grpcLockTotal);
        tags = new ArrayList();
        tags.add(immutableTag);
        tags.add(new ImmutableTag("name", "grpcLockSuccess"));
        NacosMeterRegistryCenter.gauge((String)METER_REGISTRY, (String)"nacos_monitor", tags, (Number)grpcLockSuccess);
        tags = new ArrayList();
        tags.add(immutableTag);
        tags.add(new ImmutableTag("name", "grpcUnLockTotal"));
        NacosMeterRegistryCenter.gauge((String)METER_REGISTRY, (String)"nacos_monitor", tags, (Number)grpcUnLockTotal);
        tags = new ArrayList();
        tags.add(immutableTag);
        tags.add(new ImmutableTag("name", "grpcUnLockSuccess"));
        NacosMeterRegistryCenter.gauge((String)METER_REGISTRY, (String)"nacos_monitor", tags, (Number)grpcUnLockSuccess);
        tags = new ArrayList();
        tags.add(immutableTag);
        tags.add(new ImmutableTag("name", "aliveLockCount"));
        NacosMeterRegistryCenter.gauge((String)METER_REGISTRY, (String)"nacos_monitor", tags, (Number)aliveLockCount);
    }
}

