/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.lock;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.lock.LockManager;
import com.alibaba.nacos.lock.core.reentrant.AtomicLockService;
import com.alibaba.nacos.lock.exception.NacosLockException;
import com.alibaba.nacos.lock.factory.LockFactory;
import com.alibaba.nacos.lock.model.LockKey;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class NacosLockManager
implements LockManager {
    private final Map<String, LockFactory> factoryMap;
    private final ConcurrentHashMap<LockKey, AtomicLockService> atomicLockMap = new ConcurrentHashMap();

    public NacosLockManager() {
        Collection factories = NacosServiceLoader.load(LockFactory.class);
        this.factoryMap = factories.stream().collect(Collectors.toConcurrentMap(LockFactory::getLockType, lockFactory -> lockFactory));
    }

    @Override
    public AtomicLockService getMutexLock(LockKey lockKey) {
        if (lockKey == null || lockKey.getLockType() == null || lockKey.getKey() == null) {
            throw new NacosLockException("lockType or lockKey is null.");
        }
        if (!this.factoryMap.containsKey(lockKey.getLockType())) {
            throw new NacosLockException("lockType: " + lockKey.getLockType() + " is not exist.");
        }
        return this.atomicLockMap.computeIfAbsent(lockKey, lock -> {
            LockFactory lockFactory = this.factoryMap.get(lock.getLockType());
            return lockFactory.createLock(lock.getKey());
        });
    }

    @Override
    public ConcurrentHashMap<LockKey, AtomicLockService> showLocks() {
        return this.atomicLockMap;
    }

    @Override
    public AtomicLockService removeMutexLock(LockKey lockKey) {
        if (lockKey == null || lockKey.getLockType() == null || lockKey.getKey() == null) {
            throw new NacosLockException("lockType or lockKey is null.");
        }
        if (!this.factoryMap.containsKey(lockKey.getLockType())) {
            throw new NacosLockException("lockType: " + lockKey.getLockType() + " is not exist.");
        }
        return this.atomicLockMap.remove(lockKey);
    }
}

