/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.common;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.config.server.model.event.IstioConfigChangeEvent;
import com.alibaba.nacos.istio.common.NacosResourceManager;
import com.alibaba.nacos.istio.common.ResourceSnapshot;
import com.alibaba.nacos.istio.misc.Loggers;
import com.alibaba.nacos.istio.model.DestinationRule;
import com.alibaba.nacos.istio.model.PushRequest;
import com.alibaba.nacos.istio.model.VirtualService;
import com.alibaba.nacos.istio.xds.NacosXdsService;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.yaml.snakeyaml.Yaml;

@Service
@Component
public class IstioConfigProcessor {
    private NacosXdsService nacosXdsService;
    private NacosResourceManager resourceManager;
    public static final String CONFIG_REASON = "config";
    private static final String VIRTUAL_SERVICE = "VirtualService";
    private static final String DESTINATION_RULE = "DestinationRule";
    private static final String API_VERSION = "networking.istio.io/v1alpha3";
    Yaml yaml = new Yaml();

    public IstioConfigProcessor() {
        NotifyCenter.registerSubscriber((Subscriber)new Subscriber(){

            public void onEvent(Event event) {
                if (event instanceof IstioConfigChangeEvent) {
                    IstioConfigChangeEvent istioConfigChangeEvent = (IstioConfigChangeEvent)event;
                    String content = istioConfigChangeEvent.content;
                    if (IstioConfigProcessor.this.isContentValid(content) && IstioConfigProcessor.this.tryParseContent(content)) {
                        PushRequest pushRequest = new PushRequest(content, true);
                        if (null == IstioConfigProcessor.this.nacosXdsService) {
                            IstioConfigProcessor.this.nacosXdsService = (NacosXdsService)((Object)ApplicationUtils.getBean(NacosXdsService.class));
                        }
                        if (null == IstioConfigProcessor.this.resourceManager) {
                            IstioConfigProcessor.this.resourceManager = (NacosResourceManager)ApplicationUtils.getBean(NacosResourceManager.class);
                        }
                        pushRequest.addReason(IstioConfigProcessor.CONFIG_REASON);
                        ResourceSnapshot snapshot = IstioConfigProcessor.this.resourceManager.createResourceSnapshot();
                        pushRequest.setResourceSnapshot(snapshot);
                        IstioConfigProcessor.this.nacosXdsService.handleConfigEvent(pushRequest);
                    }
                }
            }

            public Class<? extends Event> subscribeType() {
                return IstioConfigChangeEvent.class;
            }
        });
    }

    public boolean isContentValid(String content) {
        Map obj;
        if (content == null || content.trim().isEmpty()) {
            Loggers.MAIN.warn("Configuration content is null or empty.");
            return false;
        }
        try {
            obj = (Map)this.yaml.load(content);
        }
        catch (Exception e) {
            Loggers.MAIN.error("Invalid YAML content.", (Throwable)e);
            return false;
        }
        String apiVersion = obj.containsKey("apiVersion") ? (String)obj.get("apiVersion") : "";
        String kind = obj.containsKey("kind") ? (String)obj.get("kind") : "";
        return API_VERSION.equals(apiVersion) && (VIRTUAL_SERVICE.equals(kind) || DESTINATION_RULE.equals(kind)) && obj.containsKey("metadata") && obj.containsKey("spec");
    }

    public boolean tryParseContent(String content) {
        if (content == null || content.trim().isEmpty()) {
            Loggers.MAIN.warn("Configuration content is null or empty.");
            return false;
        }
        try {
            Map obj = (Map)this.yaml.load(content);
            String kind = (String)obj.get("kind");
            if (VIRTUAL_SERVICE.equals(kind)) {
                VirtualService virtualService = (VirtualService)this.yaml.loadAs(content, VirtualService.class);
                Loggers.MAIN.info("Configuration Content was successfully parsed as VirtualService.");
            } else if (DESTINATION_RULE.equals(kind)) {
                DestinationRule destinationRule = (DestinationRule)this.yaml.loadAs(content, DestinationRule.class);
                Loggers.MAIN.info("Configuration Content was successfully parsed as DestinationRule.");
            } else {
                Loggers.MAIN.warn("Unknown Config : Unknown 'kind' field in content: {}", (Object)kind);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            Loggers.MAIN.error("Error parsing configuration content: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }
}

