/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.common;

import com.alibaba.nacos.istio.misc.IstioConfig;
import com.alibaba.nacos.istio.model.PushRequest;
import java.util.Date;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;

public class Debounce
implements Callable<PushRequest> {
    private Date startDebounce;
    private Date lastConfigUpdateTime;
    private final IstioConfig istioConfig;
    private final Queue<PushRequest> pushRequestQueue;
    private PushRequest pushRequest;
    private int debouncedEvents = 0;
    private boolean free = true;
    private boolean flag = false;

    public Debounce(Queue<PushRequest> pushRequestQueue, IstioConfig istioConfig) {
        this.pushRequestQueue = pushRequestQueue;
        this.istioConfig = istioConfig;
    }

    @Override
    public PushRequest call() throws Exception {
        while (!this.flag) {
            PushRequest otherRequest = this.pushRequestQueue.poll();
            if (otherRequest == null) continue;
            this.lastConfigUpdateTime = new Date();
            if (this.debouncedEvents == 0) {
                this.startDebounce = this.lastConfigUpdateTime;
                this.pushRequest = otherRequest;
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        if (Debounce.this.free) {
                            try {
                                Debounce.this.pushWorker();
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                }, this.istioConfig.getDebounceAfter());
            } else {
                this.merge(otherRequest);
            }
            ++this.debouncedEvents;
        }
        return this.pushRequest;
    }

    private void pushWorker() {
        long eventDelay = System.currentTimeMillis() - this.startDebounce.getTime();
        long quietTime = System.currentTimeMillis() - this.lastConfigUpdateTime.getTime();
        if (eventDelay > this.istioConfig.getDebounceMax() || quietTime > this.istioConfig.getDebounceAfter()) {
            if (this.pushRequest != null) {
                this.free = false;
                this.flag = true;
                this.debouncedEvents = 0;
            }
        } else {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    if (Debounce.this.free) {
                        try {
                            Debounce.this.pushWorker();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }, this.istioConfig.getDebounceAfter() - quietTime);
        }
    }

    private void merge(PushRequest otherRequest) {
        this.pushRequest.getReason().addAll(otherRequest.getReason());
        this.pushRequest.setFull(this.pushRequest.isFull() || otherRequest.isFull());
    }
}

