/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.web;

import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.web.NacosWebBean;
import com.alibaba.nacos.sys.env.EnvUtil;
import jakarta.servlet.ServletContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
@NacosWebBean
public class NacosWebServerListener
implements ApplicationListener<WebServerInitializedEvent> {
    private static final String SPRING_MANAGEMENT_CONTEXT_NAMESPACE = "management";
    private final ServerMemberManager serverMemberManager;

    public NacosWebServerListener(ServerMemberManager serverMemberManager, ServletContext servletContext) {
        this.serverMemberManager = serverMemberManager;
        EnvUtil.setContextPath((String)servletContext.getContextPath());
    }

    public void onApplicationEvent(WebServerInitializedEvent event) {
        String serverNamespace = event.getApplicationContext().getServerNamespace();
        if (SPRING_MANAGEMENT_CONTEXT_NAMESPACE.equals(serverNamespace)) {
            return;
        }
        this.serverMemberManager.setSelfReady(event.getWebServer().getPort());
    }
}

