/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.utils;

import com.alibaba.nacos.api.model.Page;
import java.util.Collections;
import java.util.List;

public class PageUtil {
    public static <T> List<T> subPageList(List<T> source, int page, int pageSize) {
        if (source.isEmpty()) {
            return source;
        }
        PageMetadata metadata = PageUtil.calculatePageMetadata(page, pageSize, source.size());
        if (source.size() > metadata.start) {
            return source.subList(metadata.start, metadata.end);
        }
        return Collections.emptyList();
    }

    public static <T> Page<T> subPage(List<T> source, int page, int pageSize) {
        Page result = new Page();
        result.setPageNumber(page);
        if (source.isEmpty()) {
            result.setPageItems(Collections.emptyList());
            return result;
        }
        int totalCount = source.size();
        result.setTotalCount(totalCount);
        PageMetadata metadata = PageUtil.calculatePageMetadata(page, pageSize, totalCount);
        int pagesAvailable = totalCount / pageSize + 1;
        result.setPagesAvailable(pagesAvailable);
        if (totalCount > metadata.start) {
            result.setPageItems(source.subList(metadata.start, metadata.end));
        }
        return result;
    }

    private static PageMetadata calculatePageMetadata(int page, int pageSize, int totalCount) {
        int start = (page - 1) * pageSize;
        if (start < 0) {
            start = 0;
        }
        int end = start + pageSize;
        if (start > totalCount) {
            start = totalCount;
        }
        if (end > totalCount) {
            end = totalCount;
        }
        PageMetadata result = new PageMetadata();
        result.start = start;
        result.end = end;
        return result;
    }

    private static class PageMetadata {
        private int start;
        private int end;

        private PageMetadata() {
        }
    }
}

