/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.service;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.response.Namespace;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.namespace.injector.NamespaceDetailInjectorHolder;
import com.alibaba.nacos.core.namespace.model.NamespaceTypeEnum;
import com.alibaba.nacos.core.namespace.model.TenantInfo;
import com.alibaba.nacos.core.namespace.repository.NamespacePersistService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class NamespaceOperationService {
    private final NamespacePersistService namespacePersistService;
    private static final String DEFAULT_NAMESPACE_SHOW_NAME = "public";
    private static final String DEFAULT_NAMESPACE_DESCRIPTION = "Default Namespace";
    private static final int DEFAULT_QUOTA = 200;
    private static final String DEFAULT_CREATE_SOURCE = "nacos";
    private static final String DEFAULT_KP = "1";

    public NamespaceOperationService(NamespacePersistService namespacePersistService) {
        this.namespacePersistService = namespacePersistService;
    }

    public List<Namespace> getNamespaceList() {
        List<TenantInfo> tenantInfos = this.namespacePersistService.findTenantByKp(DEFAULT_KP);
        Namespace namespace0 = new Namespace(NamespaceUtil.getNamespaceDefaultId(), DEFAULT_NAMESPACE_SHOW_NAME, DEFAULT_NAMESPACE_DESCRIPTION, 200, 0, NamespaceTypeEnum.GLOBAL.getType());
        NamespaceDetailInjectorHolder.getInstance().injectDetail(namespace0);
        ArrayList<Namespace> namespaceList = new ArrayList<Namespace>();
        namespaceList.add(namespace0);
        for (TenantInfo tenantInfo : tenantInfos) {
            Namespace namespaceTmp = new Namespace(tenantInfo.getTenantId(), tenantInfo.getTenantName(), tenantInfo.getTenantDesc(), 200, 0, NamespaceTypeEnum.CUSTOM.getType());
            NamespaceDetailInjectorHolder.getInstance().injectDetail(namespaceTmp);
            namespaceList.add(namespaceTmp);
        }
        return namespaceList;
    }

    public Namespace getNamespace(String namespaceId) throws NacosException {
        return this.getNamespace(namespaceId, NamespaceTypeEnum.CUSTOM);
    }

    public Namespace getNamespace(String namespaceId, NamespaceTypeEnum type) throws NacosException {
        Namespace result;
        if (StringUtils.isBlank((CharSequence)namespaceId) || namespaceId.equals(NamespaceUtil.getNamespaceDefaultId())) {
            result = new Namespace(namespaceId, DEFAULT_NAMESPACE_SHOW_NAME, DEFAULT_NAMESPACE_DESCRIPTION, 200, 0, NamespaceTypeEnum.GLOBAL.getType());
        } else {
            String typeString = String.valueOf(type.getType());
            TenantInfo tenantInfo = this.namespacePersistService.findTenantByKp(typeString, namespaceId);
            if (null == tenantInfo) {
                throw new NacosApiException(HttpStatus.NOT_FOUND.value(), ErrorCode.NAMESPACE_NOT_EXIST, "namespaceId [ " + namespaceId + " ] not exist");
            }
            result = new Namespace(namespaceId, tenantInfo.getTenantName(), tenantInfo.getTenantDesc(), 200, 0, NamespaceTypeEnum.CUSTOM.getType());
        }
        NamespaceDetailInjectorHolder.getInstance().injectDetail(result);
        return result;
    }

    public Boolean createNamespace(String namespaceId, String namespaceName, String namespaceDesc) throws NacosException {
        return this.createNamespace(namespaceId, namespaceName, namespaceDesc, NamespaceTypeEnum.CUSTOM);
    }

    public Boolean createNamespace(String namespaceId, String namespaceName, String namespaceDesc, NamespaceTypeEnum type) throws NacosException {
        this.isNamespaceExist(namespaceId);
        String typeString = String.valueOf(type.getType());
        this.namespacePersistService.insertTenantInfoAtomic(typeString, namespaceId, namespaceName, namespaceDesc, DEFAULT_CREATE_SOURCE, System.currentTimeMillis());
        return true;
    }

    public Boolean editNamespace(String namespaceId, String namespaceName, String namespaceDesc) {
        this.namespacePersistService.updateTenantNameAtomic(DEFAULT_KP, namespaceId, namespaceName, namespaceDesc);
        return true;
    }

    public Boolean removeNamespace(String namespaceId) {
        this.namespacePersistService.removeTenantInfoAtomic(DEFAULT_KP, namespaceId);
        return true;
    }

    public boolean isNamespaceExist(String namespaceId) throws NacosApiException {
        if (NamespaceUtil.isDefaultNamespaceId((String)namespaceId)) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.NAMESPACE_ALREADY_EXIST, "namespaceId [" + namespaceId + "] is default namespace id and already exist.");
        }
        if (this.namespacePersistService.tenantInfoCountByTenantId(namespaceId) > 0) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.NAMESPACE_ALREADY_EXIST, "namespaceId [" + namespaceId + "] already exist.");
        }
        return false;
    }
}

