/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.service;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.response.ServerLoaderMetric;
import com.alibaba.nacos.api.model.response.ServerLoaderMetrics;
import com.alibaba.nacos.api.remote.RequestCallBack;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.request.ServerLoaderInfoRequest;
import com.alibaba.nacos.api.remote.request.ServerReloadRequest;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.api.remote.response.ServerLoaderInfoResponse;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.cluster.remote.ClusterRpcClientProxy;
import com.alibaba.nacos.core.remote.Connection;
import com.alibaba.nacos.core.remote.ConnectionManager;
import com.alibaba.nacos.core.remote.core.ServerLoaderInfoRequestHandler;
import com.alibaba.nacos.core.remote.core.ServerReloaderRequestHandler;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NacosServerLoaderService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosServerLoaderService.class);
    private final ConnectionManager connectionManager;
    private final ServerMemberManager serverMemberManager;
    private final ClusterRpcClientProxy clusterRpcClientProxy;
    private final ServerReloaderRequestHandler serverReloaderRequestHandler;
    private final ServerLoaderInfoRequestHandler serverLoaderInfoRequestHandler;

    public NacosServerLoaderService(ConnectionManager connectionManager, ServerMemberManager serverMemberManager, ClusterRpcClientProxy clusterRpcClientProxy, ServerReloaderRequestHandler serverReloaderRequestHandler, ServerLoaderInfoRequestHandler serverLoaderInfoRequestHandler) {
        this.connectionManager = connectionManager;
        this.serverMemberManager = serverMemberManager;
        this.clusterRpcClientProxy = clusterRpcClientProxy;
        this.serverReloaderRequestHandler = serverReloaderRequestHandler;
        this.serverLoaderInfoRequestHandler = serverLoaderInfoRequestHandler;
    }

    public Map<String, Connection> getAllClients() {
        return this.connectionManager.currentClients();
    }

    public void reloadClient(String connectionId, String redirectAddress) {
        this.connectionManager.loadSingle(connectionId, redirectAddress);
    }

    public void reloadCount(int count, String redirectAddress) {
        this.connectionManager.loadCount(count, redirectAddress);
    }

    public boolean smartReload(float loaderFactor) {
        ServerLoaderMetrics serverLoadMetrics = this.getServerLoaderMetrics();
        List details = serverLoadMetrics.getDetail();
        int overLimitCount = (int)((float)serverLoadMetrics.getAvg() * (1.0f + loaderFactor));
        int lowLimitCount = (int)((float)serverLoadMetrics.getAvg() * (1.0f - loaderFactor));
        List overLimitServer = details.stream().filter(metric -> metric.getSdkConCount() > overLimitCount).collect(Collectors.toList());
        List lowLimitServer = details.stream().filter(metric -> metric.getSdkConCount() < lowLimitCount).collect(Collectors.toList());
        overLimitServer.sort(Comparator.comparingInt(ServerLoaderMetric::getSdkConCount).reversed());
        LOGGER.info("Over load limit server list ={}", overLimitServer);
        lowLimitServer.sort(Comparator.comparingInt(ServerLoaderMetric::getSdkConCount));
        LOGGER.info("Low load limit server list ={}", lowLimitServer);
        final AtomicBoolean result = new AtomicBoolean(true);
        int i = 0;
        while (i < overLimitServer.size() & i < lowLimitServer.size()) {
            ServerReloadRequest serverLoaderInfoRequest = new ServerReloadRequest();
            serverLoaderInfoRequest.setReloadCount(overLimitCount);
            serverLoaderInfoRequest.setReloadServer(((ServerLoaderMetric)lowLimitServer.get(i)).getAddress());
            final Member member = this.serverMemberManager.find(((ServerLoaderMetric)overLimitServer.get(i)).getAddress());
            LOGGER.info("Reload task submit ,fromServer ={},toServer={}, ", (Object)((ServerLoaderMetric)overLimitServer.get(i)).getAddress(), (Object)((ServerLoaderMetric)lowLimitServer.get(i)).getAddress());
            if (this.serverMemberManager.getSelf().equals(member)) {
                try {
                    this.serverReloaderRequestHandler.handle(serverLoaderInfoRequest, new RequestMeta());
                }
                catch (NacosException e) {
                    LOGGER.error("Fail to loader self server", (Throwable)e);
                    result.set(false);
                }
            } else {
                try {
                    this.clusterRpcClientProxy.asyncRequest(member, (Request)serverLoaderInfoRequest, new RequestCallBack(){

                        public Executor getExecutor() {
                            return null;
                        }

                        public long getTimeout() {
                            return 100L;
                        }

                        public void onResponse(Response response) {
                            if (response == null || !response.isSuccess()) {
                                LOGGER.error("Fail to loader member={},response={}", (Object)member.getAddress(), (Object)response);
                                result.set(false);
                            }
                        }

                        public void onException(Throwable e) {
                            LOGGER.error("Fail to loader member={}", (Object)member.getAddress(), (Object)e);
                            result.set(false);
                        }
                    });
                }
                catch (NacosException e) {
                    LOGGER.error("Fail to loader member={}", (Object)member.getAddress(), (Object)e);
                    result.set(false);
                }
            }
            ++i;
        }
        return result.get();
    }

    public ServerLoaderMetrics getServerLoaderMetrics() {
        CopyOnWriteArrayList<ServerLoaderMetric> responseList = new CopyOnWriteArrayList<ServerLoaderMetric>();
        int memberSize = this.serverMemberManager.allMembersWithoutSelf().size();
        CountDownLatch countDownLatch = new CountDownLatch(memberSize);
        for (Member member : this.serverMemberManager.allMembersWithoutSelf()) {
            ServerLoaderInfoRequest serverLoaderInfoRequest = new ServerLoaderInfoRequest();
            ServerLoaderMetricCallBack callBack = new ServerLoaderMetricCallBack(member, responseList, countDownLatch);
            try {
                this.clusterRpcClientProxy.asyncRequest(member, (Request)serverLoaderInfoRequest, callBack);
            }
            catch (NacosException e) {
                LOGGER.error("Get metrics fail,member={}", (Object)member.getAddress(), (Object)e);
                countDownLatch.countDown();
            }
        }
        responseList.add(this.getSelfServerLoaderMetric());
        this.waitAsyncGetLoaderMetricFinish(countDownLatch);
        int max = responseList.stream().mapToInt(ServerLoaderMetric::getSdkConCount).max().orElse(0);
        int min = responseList.stream().mapToInt(ServerLoaderMetric::getSdkConCount).min().orElse(0);
        int total = responseList.stream().mapToInt(ServerLoaderMetric::getSdkConCount).sum();
        responseList.sort(Comparator.comparing(ServerLoaderMetric::getAddress));
        return this.buildMetrics(responseList, max, min, total);
    }

    private ServerLoaderMetric getSelfServerLoaderMetric() {
        ServerLoaderMetric.Builder builder = ServerLoaderMetric.Builder.newBuilder();
        builder.withAddress(this.serverMemberManager.getSelf().getAddress());
        try {
            ServerLoaderInfoResponse handle = this.serverLoaderInfoRequestHandler.handle(new ServerLoaderInfoRequest(), new RequestMeta());
            builder.convertFromMap(handle.getLoaderMetrics());
        }
        catch (NacosException e) {
            LOGGER.error("Get self metrics fail", (Throwable)e);
        }
        return builder.build();
    }

    private void waitAsyncGetLoaderMetricFinish(CountDownLatch countDownLatch) {
        try {
            countDownLatch.await(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Get  metrics timeout,metrics info may not complete.");
        }
    }

    private ServerLoaderMetrics buildMetrics(List<ServerLoaderMetric> responseList, int max, int min, int total) {
        ServerLoaderMetrics serverLoaderMetrics = new ServerLoaderMetrics();
        serverLoaderMetrics.setDetail(responseList);
        serverLoaderMetrics.setMemberCount(this.serverMemberManager.allMembers().size());
        serverLoaderMetrics.setMetricsCount(responseList.size());
        serverLoaderMetrics.setCompleted(responseList.size() == this.serverMemberManager.allMembers().size());
        serverLoaderMetrics.setMax(max);
        serverLoaderMetrics.setMin(min);
        serverLoaderMetrics.setAvg(total / responseList.size());
        serverLoaderMetrics.setThreshold(String.valueOf((double)serverLoaderMetrics.getAvg() * 1.1));
        serverLoaderMetrics.setTotal(total);
        return serverLoaderMetrics;
    }

    private static class ServerLoaderMetricCallBack
    implements RequestCallBack<Response> {
        private final Member member;
        private final List<ServerLoaderMetric> responseList;
        private final CountDownLatch countDownLatch;

        private ServerLoaderMetricCallBack(Member member, List<ServerLoaderMetric> responseList, CountDownLatch countDownLatch) {
            this.member = member;
            this.responseList = responseList;
            this.countDownLatch = countDownLatch;
        }

        public Executor getExecutor() {
            return null;
        }

        public long getTimeout() {
            return 200L;
        }

        public void onResponse(Response response) {
            if (response instanceof ServerLoaderInfoResponse) {
                ServerLoaderMetric.Builder builder = ServerLoaderMetric.Builder.newBuilder();
                builder.withAddress(this.member.getAddress()).convertFromMap(((ServerLoaderInfoResponse)response).getLoaderMetrics());
                this.responseList.add(builder.build());
            }
            this.countDownLatch.countDown();
        }

        public void onException(Throwable e) {
            LOGGER.error("Get metrics fail,member={}", (Object)this.member.getAddress(), (Object)e);
            this.countDownLatch.countDown();
        }
    }
}

