/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.service;

import com.alibaba.nacos.api.common.NodeState;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.utils.LoggerUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.model.request.LookupUpdateRequest;
import com.alibaba.nacos.core.utils.Loggers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class NacosClusterOperationService {
    private final ServerMemberManager memberManager;

    public NacosClusterOperationService(ServerMemberManager memberManager) {
        this.memberManager = memberManager;
    }

    public Member self() {
        return this.memberManager.getSelf();
    }

    public Collection<Member> listNodes(String address, NodeState nodeState) throws NacosException {
        Collection<Member> members = this.memberManager.allMembers();
        ArrayList<Member> result = new ArrayList<Member>();
        for (Member member : members) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{address}) && !StringUtils.startsWith((CharSequence)member.getAddress(), (CharSequence)address) || nodeState != null && member.getState() != nodeState) continue;
            result.add(member);
        }
        return result;
    }

    public Boolean updateNodes(List<Member> nodes) {
        for (Member node : nodes) {
            if (!node.check()) {
                LoggerUtils.printIfWarnEnabled((Logger)Loggers.CLUSTER, (String)"node information is illegal, ignore node: {}", (Object[])new Object[]{node});
                continue;
            }
            LoggerUtils.printIfDebugEnabled((Logger)Loggers.CLUSTER, (String)"node state updating, node: {}", (Object[])new Object[]{node});
            node.setState(NodeState.UP);
            node.setFailAccessCnt(0);
            boolean update = this.memberManager.update(node);
            if (update) continue;
            LoggerUtils.printIfErrorEnabled((Logger)Loggers.CLUSTER, (String)"node state update failed, node: {}", (Object[])new Object[]{node});
        }
        return true;
    }

    public Boolean updateLookup(LookupUpdateRequest request) throws NacosException {
        this.memberManager.switchLookup(request.getType());
        return true;
    }

    public String selfHealth() {
        return this.memberManager.getSelf().getState().name();
    }
}

