/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.grpc.negotiator.tls;

import com.alibaba.nacos.core.remote.grpc.negotiator.NacosGrpcProtocolNegotiator;
import com.alibaba.nacos.core.remote.grpc.negotiator.tls.DefaultTlsContextBuilder;
import com.alibaba.nacos.core.remote.tls.RpcServerTlsConfig;
import io.grpc.netty.shaded.io.grpc.netty.GrpcHttp2ConnectionHandler;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiators;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiationEvent;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.netty.shaded.io.netty.util.Attribute;
import io.grpc.netty.shaded.io.netty.util.AttributeKey;
import java.lang.reflect.Field;
import java.util.List;

public class OptionalTlsProtocolNegotiator
implements NacosGrpcProtocolNegotiator {
    private static final int MAGIC_VALUE = 5;
    private final boolean supportPlainText;
    private final RpcServerTlsConfig config;
    private SslContext sslContext;

    public OptionalTlsProtocolNegotiator(SslContext sslContext, RpcServerTlsConfig config) {
        this.sslContext = sslContext;
        this.config = config;
        this.supportPlainText = config.getCompatibility();
    }

    void setSslContext(SslContext sslContext) {
        this.sslContext = sslContext;
    }

    public AsciiString scheme() {
        return AsciiString.of((CharSequence)"https");
    }

    public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHttp2ConnectionHandler) {
        ChannelHandler plaintext = InternalProtocolNegotiators.serverPlaintext().newHandler(grpcHttp2ConnectionHandler);
        ChannelHandler ssl = InternalProtocolNegotiators.serverTls((SslContext)this.sslContext).newHandler(grpcHttp2ConnectionHandler);
        return new PortUnificationServerHandler(ssl, plaintext);
    }

    public void close() {
    }

    @Override
    public void reloadNegotiator() {
        if (this.config.getEnableTls().booleanValue()) {
            this.sslContext = DefaultTlsContextBuilder.getSslContext(this.config);
        }
    }

    private ProtocolNegotiationEvent getDefPne() {
        try {
            Field aDefault = ProtocolNegotiationEvent.class.getDeclaredField("DEFAULT");
            aDefault.setAccessible(true);
            return (ProtocolNegotiationEvent)aDefault.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public class PortUnificationServerHandler
    extends ByteToMessageDecoder {
        private final ProtocolNegotiationEvent pne;
        private final ChannelHandler ssl;
        private final ChannelHandler plaintext;

        public PortUnificationServerHandler(ChannelHandler ssl, ChannelHandler plaintext) {
            this.ssl = ssl;
            this.plaintext = plaintext;
            this.pne = OptionalTlsProtocolNegotiator.this.getDefPne();
        }

        private boolean isSsl(ByteBuf buf) {
            return SslHandler.isEncrypted((ByteBuf)buf);
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            if (in.readableBytes() < 5) {
                return;
            }
            Attribute tlsProtected = ctx.channel().attr(AttributeKey.valueOf((String)"TLS_PROTECTED"));
            if (this.isSsl(in) || !OptionalTlsProtocolNegotiator.this.supportPlainText) {
                tlsProtected.set((Object)true);
                ctx.pipeline().addAfter(ctx.name(), null, this.ssl);
            } else {
                tlsProtected.set((Object)false);
                ctx.pipeline().addAfter(ctx.name(), null, this.plaintext);
            }
            ctx.fireUserEventTriggered((Object)this.pne);
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }
}

