/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.grpc;

import com.alibaba.nacos.api.common.Constants;
import com.alibaba.nacos.core.remote.grpc.BaseGrpcServer;
import com.alibaba.nacos.core.remote.grpc.filter.NacosGrpcServerTransportFilterServiceLoader;
import com.alibaba.nacos.core.remote.grpc.interceptor.NacosGrpcServerInterceptorServiceLoader;
import com.alibaba.nacos.core.remote.grpc.negotiator.ClusterProtocolNegotiatorBuilderSingleton;
import com.alibaba.nacos.core.utils.GlobalExecutor;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import io.grpc.ServerInterceptor;
import io.grpc.ServerTransportFilter;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.stereotype.Service;

@Service
public class GrpcClusterServer
extends BaseGrpcServer {
    @Override
    public int rpcPortOffset() {
        return Constants.CLUSTER_GRPC_PORT_DEFAULT_OFFSET;
    }

    @Override
    public ThreadPoolExecutor getRpcExecutor() {
        if (!GlobalExecutor.clusterRpcExecutor.allowsCoreThreadTimeOut()) {
            GlobalExecutor.clusterRpcExecutor.allowCoreThreadTimeOut(true);
        }
        return GlobalExecutor.clusterRpcExecutor;
    }

    @Override
    protected long getKeepAliveTime() {
        Long property = (Long)EnvUtil.getProperty((String)"nacos.remote.server.grpc.cluster.keep-alive-time", Long.class);
        if (property != null) {
            return property;
        }
        return super.getKeepAliveTime();
    }

    @Override
    protected long getKeepAliveTimeout() {
        Long property = (Long)EnvUtil.getProperty((String)"nacos.remote.server.grpc.cluster.keep-alive-timeout", Long.class);
        if (property != null) {
            return property;
        }
        return super.getKeepAliveTimeout();
    }

    @Override
    protected Optional<InternalProtocolNegotiator.ProtocolNegotiator> newProtocolNegotiator() {
        this.protocolNegotiator = ClusterProtocolNegotiatorBuilderSingleton.getSingleton().build();
        return Optional.ofNullable(this.protocolNegotiator);
    }

    @Override
    protected long getPermitKeepAliveTime() {
        Long property = (Long)EnvUtil.getProperty((String)"nacos.remote.server.grpc.cluster.permit-keep-alive-time", Long.class);
        if (property != null) {
            return property;
        }
        return super.getPermitKeepAliveTime();
    }

    @Override
    protected int getMaxInboundMessageSize() {
        Integer property = (Integer)EnvUtil.getProperty((String)"nacos.remote.server.grpc.cluster.max-inbound-message-size", Integer.class);
        if (property != null) {
            return property;
        }
        int size = super.getMaxInboundMessageSize();
        if (Loggers.REMOTE.isWarnEnabled()) {
            Loggers.REMOTE.warn("Recommended use '{}' property instead '{}', now property value is {}", new Object[]{"nacos.remote.server.grpc.cluster.max-inbound-message-size", "nacos.remote.server.grpc.maxinbound.message.size", size});
        }
        return size;
    }

    @Override
    protected List<ServerInterceptor> getSeverInterceptors() {
        LinkedList<ServerInterceptor> result = new LinkedList<ServerInterceptor>();
        result.addAll(super.getSeverInterceptors());
        result.addAll(NacosGrpcServerInterceptorServiceLoader.loadServerInterceptors("CLUSTER"));
        return result;
    }

    @Override
    protected List<ServerTransportFilter> getServerTransportFilters() {
        LinkedList<ServerTransportFilter> result = new LinkedList<ServerTransportFilter>();
        result.addAll(super.getServerTransportFilters());
        result.addAll(NacosGrpcServerTransportFilterServiceLoader.loadServerTransportFilters("CLUSTER"));
        return result;
    }

    @Override
    protected String getSource() {
        return "cluster";
    }
}

