/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.grpc;

import com.alibaba.nacos.api.ability.constant.AbilityMode;
import com.alibaba.nacos.api.grpc.auto.BiRequestStreamGrpc;
import com.alibaba.nacos.api.grpc.auto.Payload;
import com.alibaba.nacos.api.remote.request.ConnectionSetupRequest;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.SetupAckRequest;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.common.ability.discover.NacosAbilityManagerHolder;
import com.alibaba.nacos.common.remote.ConnectionType;
import com.alibaba.nacos.common.remote.client.grpc.GrpcUtils;
import com.alibaba.nacos.core.remote.ConnectionManager;
import com.alibaba.nacos.core.remote.ConnectionMeta;
import com.alibaba.nacos.core.remote.RpcAckCallbackSynchronizer;
import com.alibaba.nacos.core.remote.grpc.GrpcConnection;
import com.alibaba.nacos.core.remote.grpc.GrpcServerConstants;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.util.Attribute;
import io.grpc.netty.shaded.io.netty.util.AttributeKey;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GrpcBiStreamRequestAcceptor
extends BiRequestStreamGrpc.BiRequestStreamImplBase {
    @Autowired
    ConnectionManager connectionManager;

    private void traceDetailIfNecessary(Payload grpcRequest) {
        String clientIp = grpcRequest.getMetadata().getClientIp();
        String connectionId = (String)GrpcServerConstants.CONTEXT_KEY_CONN_ID.get();
        try {
            if (this.connectionManager.traced(clientIp)) {
                Loggers.REMOTE_DIGEST.info("[{}]Bi stream request receive, meta={},body={}", new Object[]{connectionId, grpcRequest.getMetadata().toByteString().toStringUtf8(), grpcRequest.getBody().toByteString().toStringUtf8()});
            }
        }
        catch (Throwable throwable) {
            Loggers.REMOTE_DIGEST.error("[{}]Bi stream request error,payload={},error={}", new Object[]{connectionId, grpcRequest.toByteString().toStringUtf8(), throwable});
        }
    }

    public StreamObserver<Payload> requestBiStream(final StreamObserver<Payload> responseObserver) {
        StreamObserver<Payload> streamObserver = new StreamObserver<Payload>(){
            final String connectionId = (String)GrpcServerConstants.CONTEXT_KEY_CONN_ID.get();
            final Integer localPort = (Integer)GrpcServerConstants.CONTEXT_KEY_CONN_LOCAL_PORT.get();
            final int remotePort = (Integer)GrpcServerConstants.CONTEXT_KEY_CONN_REMOTE_PORT.get();
            String remoteIp = (String)GrpcServerConstants.CONTEXT_KEY_CONN_REMOTE_IP.get();
            String clientIp = "";

            public void onNext(Payload payload) {
                GrpcBiStreamRequestAcceptor.this.streamObserverOnNext(payload, this.connectionId, this.localPort, this.remotePort, this.remoteIp, (StreamObserver<Payload>)responseObserver);
            }

            public void onError(Throwable t) {
                ServerCallStreamObserver serverCallStreamObserver;
                if (GrpcBiStreamRequestAcceptor.this.connectionManager.traced(this.clientIp)) {
                    Loggers.REMOTE_DIGEST.warn("[{}]Bi stream on error,error={}", (Object)this.connectionId, (Object)t);
                }
                if (responseObserver instanceof ServerCallStreamObserver && !(serverCallStreamObserver = (ServerCallStreamObserver)responseObserver).isCancelled()) {
                    try {
                        serverCallStreamObserver.onCompleted();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }

            public void onCompleted() {
                ServerCallStreamObserver serverCallStreamObserver;
                if (GrpcBiStreamRequestAcceptor.this.connectionManager.traced(this.clientIp)) {
                    Loggers.REMOTE_DIGEST.warn("[{}]Bi stream on completed", (Object)this.connectionId);
                }
                if (responseObserver instanceof ServerCallStreamObserver && !(serverCallStreamObserver = (ServerCallStreamObserver)responseObserver).isCancelled()) {
                    try {
                        serverCallStreamObserver.onCompleted();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        };
        return streamObserver;
    }

    private void streamObserverOnNext(Payload payload, String connectionId, Integer localPort, int remotePort, String remoteIp, StreamObserver<Payload> responseObserver) {
        block17: {
            Object parseObj;
            String clientIp = payload.getMetadata().getClientIp();
            this.traceDetailIfNecessary(payload);
            try {
                parseObj = GrpcUtils.parse((Payload)payload);
            }
            catch (Throwable throwable) {
                Loggers.REMOTE_DIGEST.warn("[{}]Grpc request bi stream,payload parse error={}", (Object)connectionId, (Object)throwable);
                return;
            }
            if (parseObj == null) {
                Loggers.REMOTE_DIGEST.warn("[{}]Grpc request bi stream,payload parse null ,body={},meta={}", new Object[]{connectionId, payload.getBody().getValue().toStringUtf8(), payload.getMetadata()});
                return;
            }
            if (parseObj instanceof ConnectionSetupRequest) {
                boolean rejectSdkOnStarting;
                ConnectionSetupRequest setUpRequest = (ConnectionSetupRequest)parseObj;
                Map labels = setUpRequest.getLabels();
                String appName = "-";
                if (labels != null && labels.containsKey("AppName")) {
                    appName = (String)labels.get("AppName");
                }
                ConnectionMeta metaInfo = new ConnectionMeta(connectionId, payload.getMetadata().getClientIp(), remoteIp, remotePort, localPort, ConnectionType.GRPC.getType(), setUpRequest.getClientVersion(), appName, setUpRequest.getLabels());
                metaInfo.setNamespaceId(setUpRequest.getTenant());
                Channel channel = (Channel)GrpcServerConstants.CONTEXT_KEY_CHANNEL.get();
                Attribute tlsProtected = channel.attr(AttributeKey.valueOf((String)"TLS_PROTECTED"));
                metaInfo.setTlsProtected(tlsProtected != null && tlsProtected.get() != null && (Boolean)tlsProtected.get() != false);
                GrpcConnection connection = new GrpcConnection(metaInfo, responseObserver, (Channel)GrpcServerConstants.CONTEXT_KEY_CHANNEL.get());
                if (setUpRequest.getAbilityTable() != null) {
                    connection.setAbilityTable(setUpRequest.getAbilityTable());
                }
                boolean bl = rejectSdkOnStarting = metaInfo.isSdkSource() && !ApplicationUtils.isStarted();
                if (rejectSdkOnStarting || !this.connectionManager.register(connectionId, connection)) {
                    try {
                        Loggers.REMOTE_DIGEST.warn("[{}]Connection register fail,reason:{}", (Object)connectionId, (Object)(rejectSdkOnStarting ? " server is not started" : " server is over limited."));
                        connection.close();
                    }
                    catch (Exception e) {
                        if (this.connectionManager.traced(clientIp)) {
                            Loggers.REMOTE_DIGEST.warn("[{}]Send connect reset request error,error={}", (Object)connectionId, (Object)e);
                        }
                        break block17;
                    }
                }
                try {
                    if (setUpRequest.getAbilityTable() != null) {
                        connection.sendRequestNoAck((Request)new SetupAckRequest(NacosAbilityManagerHolder.getInstance().getCurrentNodeAbilities(AbilityMode.SERVER)));
                    }
                }
                catch (Exception exception) {}
            } else if (parseObj instanceof Response) {
                Response response = (Response)parseObj;
                if (this.connectionManager.traced(clientIp)) {
                    Loggers.REMOTE_DIGEST.warn("[{}]Receive response of server request  ,response={}", (Object)connectionId, (Object)response);
                }
                RpcAckCallbackSynchronizer.ackNotify(connectionId, response);
                this.connectionManager.refreshActiveTime(connectionId);
            } else {
                Loggers.REMOTE_DIGEST.warn("[{}]Grpc request bi stream,unknown payload receive ,parseObj={}", (Object)connectionId, parseObj);
            }
        }
    }
}

