/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.grpc;

import com.alibaba.nacos.api.grpc.auto.Payload;
import com.alibaba.nacos.api.remote.response.ErrorResponse;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.common.remote.ConnectionType;
import com.alibaba.nacos.common.remote.client.grpc.GrpcUtils;
import com.alibaba.nacos.core.monitor.MetricsMonitor;
import com.alibaba.nacos.core.remote.BaseRpcServer;
import com.alibaba.nacos.core.remote.ConnectionManager;
import com.alibaba.nacos.core.remote.RequestHandlerRegistry;
import com.alibaba.nacos.core.remote.grpc.AddressTransportFilter;
import com.alibaba.nacos.core.remote.grpc.GrpcBiStreamRequestAcceptor;
import com.alibaba.nacos.core.remote.grpc.GrpcConnectionInterceptor;
import com.alibaba.nacos.core.remote.grpc.GrpcRequestAcceptor;
import com.alibaba.nacos.core.remote.grpc.GrpcServerConstants;
import com.alibaba.nacos.core.remote.grpc.negotiator.NacosGrpcProtocolNegotiator;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.google.protobuf.Message;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.HandlerRegistry;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServerTransportFilter;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiator;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.grpc.util.MutableHandlerRegistry;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseGrpcServer
extends BaseRpcServer {
    protected NacosGrpcProtocolNegotiator protocolNegotiator;
    private Server server;
    @Autowired
    private GrpcRequestAcceptor grpcCommonRequestAcceptor;
    @Autowired
    private GrpcBiStreamRequestAcceptor grpcBiStreamRequestAcceptor;
    @Autowired
    private ConnectionManager connectionManager;
    @Autowired
    private RequestHandlerRegistry requestHandlerRegistry;

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.GRPC;
    }

    @Override
    public void startServer() throws Exception {
        MutableHandlerRegistry handlerRegistry = new MutableHandlerRegistry();
        this.addServices(handlerRegistry, this.getSeverInterceptors().toArray(new ServerInterceptor[0]));
        NettyServerBuilder builder = (NettyServerBuilder)NettyServerBuilder.forPort((int)this.getServicePort()).executor((Executor)this.getRpcExecutor());
        Optional<InternalProtocolNegotiator.ProtocolNegotiator> negotiator = this.newProtocolNegotiator();
        if (negotiator.isPresent()) {
            InternalProtocolNegotiator.ProtocolNegotiator actual = negotiator.get();
            Loggers.REMOTE.info("Add protocol negotiator {}", (Object)actual.getClass().getCanonicalName());
            builder.protocolNegotiator((ProtocolNegotiator)actual);
        }
        for (ServerTransportFilter each : this.getServerTransportFilters()) {
            builder.addTransportFilter(each);
        }
        this.server = ((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)builder.maxInboundMessageSize(this.getMaxInboundMessageSize()).fallbackHandlerRegistry((HandlerRegistry)handlerRegistry)).compressorRegistry(CompressorRegistry.getDefaultInstance())).decompressorRegistry(DecompressorRegistry.getDefaultInstance())).keepAliveTime(this.getKeepAliveTime(), TimeUnit.MILLISECONDS).keepAliveTimeout(this.getKeepAliveTimeout(), TimeUnit.MILLISECONDS).permitKeepAliveTime(this.getPermitKeepAliveTime(), TimeUnit.MILLISECONDS).build();
        this.server.start();
    }

    @Override
    public void reloadProtocolContext() {
        this.reloadProtocolNegotiator();
    }

    protected Optional<InternalProtocolNegotiator.ProtocolNegotiator> newProtocolNegotiator() {
        return Optional.empty();
    }

    public void reloadProtocolNegotiator() {
        if (this.protocolNegotiator != null) {
            try {
                this.protocolNegotiator.reloadNegotiator();
            }
            catch (Throwable throwable) {
                Loggers.REMOTE.info("Nacos {} Rpc server reload negotiator fail at port {}.", (Object)this.getClass().getSimpleName(), (Object)this.getServicePort());
                throw throwable;
            }
        }
    }

    protected long getPermitKeepAliveTime() {
        return GrpcServerConstants.GrpcConfig.DEFAULT_GRPC_PERMIT_KEEP_ALIVE_TIME;
    }

    protected long getKeepAliveTime() {
        return GrpcServerConstants.GrpcConfig.DEFAULT_GRPC_KEEP_ALIVE_TIME;
    }

    protected long getKeepAliveTimeout() {
        return GrpcServerConstants.GrpcConfig.DEFAULT_GRPC_KEEP_ALIVE_TIMEOUT;
    }

    protected int getMaxInboundMessageSize() {
        Integer property = (Integer)EnvUtil.getProperty((String)"nacos.remote.server.grpc.maxinbound.message.size", Integer.class);
        if (property != null) {
            return property;
        }
        return 0xA00000;
    }

    protected List<ServerInterceptor> getSeverInterceptors() {
        LinkedList<ServerInterceptor> result = new LinkedList<ServerInterceptor>();
        result.add(new GrpcConnectionInterceptor());
        return result;
    }

    protected List<ServerTransportFilter> getServerTransportFilters() {
        return Collections.singletonList(new AddressTransportFilter(this.connectionManager));
    }

    protected abstract String getSource();

    private boolean invokeSourceAllowCheck(Payload grpcRequest) {
        return this.requestHandlerRegistry.checkSourceInvokeAllowed(grpcRequest.getMetadata().getType(), this.getSource());
    }

    protected void handleCommonRequest(Payload grpcRequest, StreamObserver<Payload> responseObserver) {
        if (!this.invokeSourceAllowCheck(grpcRequest)) {
            Payload payloadResponse = GrpcUtils.convert((Response)ErrorResponse.build((int)502, (String)String.format(" invoke %s from %s is forbidden", grpcRequest.getMetadata().getType(), this.getSource())));
            responseObserver.onNext((Object)payloadResponse);
            responseObserver.onCompleted();
            MetricsMonitor.recordGrpcRequestEvent(grpcRequest.getMetadata().getType(), false, 502, null, null, 0L);
        } else {
            this.grpcCommonRequestAcceptor.request(grpcRequest, responseObserver);
        }
    }

    private void addServices(MutableHandlerRegistry handlerRegistry, ServerInterceptor ... serverInterceptor) {
        MethodDescriptor unaryPayloadMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)"Request", (String)"request")).setRequestMarshaller(ProtoUtils.marshaller((Message)Payload.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Payload.getDefaultInstance())).build();
        ServerCallHandler payloadHandler = ServerCalls.asyncUnaryCall((request, responseObserver) -> this.handleCommonRequest((Payload)request, (StreamObserver<Payload>)responseObserver));
        ServerServiceDefinition serviceDefOfUnaryPayload = ServerServiceDefinition.builder((String)"Request").addMethod(unaryPayloadMethod, payloadHandler).build();
        handlerRegistry.addService(ServerInterceptors.intercept((ServerServiceDefinition)serviceDefOfUnaryPayload, (ServerInterceptor[])serverInterceptor));
        ServerCallHandler biStreamHandler = ServerCalls.asyncBidiStreamingCall(responseObserver -> this.grpcBiStreamRequestAcceptor.requestBiStream((StreamObserver<Payload>)responseObserver));
        MethodDescriptor biStreamMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName((String)"BiRequestStream", (String)"requestBiStream")).setRequestMarshaller(ProtoUtils.marshaller((Message)Payload.newBuilder().build())).setResponseMarshaller(ProtoUtils.marshaller((Message)Payload.getDefaultInstance())).build();
        ServerServiceDefinition serviceDefOfBiStream = ServerServiceDefinition.builder((String)"BiRequestStream").addMethod(biStreamMethod, biStreamHandler).build();
        handlerRegistry.addService(ServerInterceptors.intercept((ServerServiceDefinition)serviceDefOfBiStream, (ServerInterceptor[])serverInterceptor));
    }

    @Override
    public void shutdownServer() {
        if (this.server != null) {
            this.server.shutdownNow();
        }
    }

    public abstract ThreadPoolExecutor getRpcExecutor();
}

