/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote;

import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.control.TpsControlConfig;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.core.remote.grpc.InvokeSource;
import com.alibaba.nacos.plugin.control.ControlManagerCenter;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Service;

@Service
public class RequestHandlerRegistry
implements ApplicationListener<ContextRefreshedEvent> {
    Map<String, RequestHandler> registryHandlers = new HashMap<String, RequestHandler>();
    Map<String, Set<String>> sourceRegistry = new HashMap<String, Set<String>>();

    public RequestHandler getByRequestType(String requestType) {
        return this.registryHandlers.get(requestType);
    }

    public boolean checkSourceInvokeAllowed(String type, String source) {
        return !this.sourceRegistry.containsKey(type) || this.sourceRegistry.get(type).contains(source);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        Map beansOfType = event.getApplicationContext().getBeansOfType(RequestHandler.class);
        Collection values = beansOfType.values();
        for (RequestHandler requestHandler : values) {
            Annotation tpsControl;
            Class<?> clazz = requestHandler.getClass();
            boolean skip = false;
            while (!clazz.getSuperclass().equals(RequestHandler.class)) {
                if (clazz.getSuperclass().equals(Object.class)) {
                    skip = true;
                    break;
                }
                clazz = clazz.getSuperclass();
            }
            if (skip) continue;
            try {
                Method method = clazz.getMethod("handle", Request.class, RequestMeta.class);
                if (method.isAnnotationPresent(TpsControl.class) && TpsControlConfig.isTpsControlEnabled()) {
                    tpsControl = method.getAnnotation(TpsControl.class);
                    String pointName = tpsControl.pointName();
                    ControlManagerCenter.getInstance().getTpsControlManager().registerTpsPoint(pointName);
                }
            }
            catch (Exception method) {
                // empty catch block
            }
            Class tClass = (Class)((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments()[0];
            try {
                Object[] sources;
                if (clazz.isAnnotationPresent(InvokeSource.class) && (sources = (tpsControl = clazz.getAnnotation(InvokeSource.class)).source()) != null && sources.length > 0) {
                    this.sourceRegistry.put(tClass.getSimpleName(), Sets.newHashSet((Object[])sources));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.registryHandlers.putIfAbsent(tClass.getSimpleName(), requestHandler);
        }
    }
}

