/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.monitor.topn;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class FixedSizePriorityQueue<T> {
    private Object[] elements;
    private int size;
    private Comparator<T> comparator;

    public FixedSizePriorityQueue(int capacity, Comparator<T> comparator) {
        this.elements = new Object[capacity];
        this.size = 0;
        this.comparator = comparator;
    }

    public void offer(T element) {
        if (this.size == this.elements.length) {
            if (this.comparator.compare(element, this.elements[0]) > 0) {
                this.elements[0] = element;
                this.siftDown();
            }
        } else {
            this.elements[this.size] = element;
            this.siftUp(this.size);
            ++this.size;
        }
    }

    private void siftUp(int index) {
        int parentIndex;
        while (index > 0 && this.comparator.compare(this.elements[index], this.elements[parentIndex = (index - 1) / 2]) <= 0) {
            this.swap(index, parentIndex);
            index = parentIndex;
        }
    }

    private void siftDown() {
        int index = 0;
        while (index * 2 + 1 < this.size) {
            int leftChild = index * 2 + 1;
            int rightChild = index * 2 + 2;
            int minChildIndex = leftChild;
            if (rightChild < this.size && this.comparator.compare(this.elements[rightChild], this.elements[leftChild]) < 0) {
                minChildIndex = rightChild;
            }
            if (this.comparator.compare(this.elements[index], this.elements[minChildIndex]) < 0) break;
            this.swap(index, minChildIndex);
            index = minChildIndex;
        }
    }

    private void swap(int i, int j) {
        Object temp = this.elements[i];
        this.elements[i] = this.elements[j];
        this.elements[j] = temp;
    }

    public List<T> toList() {
        LinkedList<Object> result = new LinkedList<Object>();
        for (int i = 0; i < this.size; ++i) {
            result.add(this.elements[i]);
        }
        return result;
    }
}

