/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.listener.startup;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.listener.startup.NacosStartUp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NacosStartUpManager {
    private static final NacosStartUpManager INSTANCE = new NacosStartUpManager();
    private String currentStartUpPhase;
    private final Map<String, NacosStartUp> startUpMap = new HashMap<String, NacosStartUp>();
    private final List<NacosStartUp> startedList;

    private NacosStartUpManager() {
        for (NacosStartUp each : NacosServiceLoader.load(NacosStartUp.class)) {
            this.startUpMap.put(each.startUpPhase(), each);
        }
        this.startedList = new ArrayList<NacosStartUp>(this.startUpMap.size());
    }

    private NacosStartUp getStartUp(String phase) {
        return this.startUpMap.get(phase);
    }

    public static void start(String phase) {
        NacosStartUp startUp = INSTANCE.getStartUp(phase);
        if (null == startUp) {
            throw new IllegalArgumentException("Unknown nacos start up phase " + phase);
        }
        NacosStartUpManager.INSTANCE.currentStartUpPhase = phase;
        NacosStartUpManager.INSTANCE.startedList.add(startUp);
    }

    public static NacosStartUp getCurrentStartUp() {
        if (StringUtils.isBlank((CharSequence)NacosStartUpManager.INSTANCE.currentStartUpPhase)) {
            throw new IllegalStateException("Nacos don't start up.");
        }
        return INSTANCE.getStartUp(NacosStartUpManager.INSTANCE.currentStartUpPhase);
    }

    public static List<NacosStartUp> getReverseStartedList() {
        ArrayList<NacosStartUp> result = new ArrayList<NacosStartUp>(NacosStartUpManager.INSTANCE.startedList);
        Collections.reverse(result);
        return result;
    }
}

