/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.listener.startup;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.common.event.ServerConfigChangeEvent;
import com.alibaba.nacos.common.executor.ThreadPoolManager;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.exception.ErrorCode;
import com.alibaba.nacos.core.listener.startup.AbstractNacosStartUp;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.file.FileChangeEvent;
import com.alibaba.nacos.sys.file.FileWatcher;
import com.alibaba.nacos.sys.file.WatchFileCenter;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import com.alibaba.nacos.sys.utils.DiskUtils;
import com.alibaba.nacos.sys.utils.InetUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;

public class NacosCoreStartUp
extends AbstractNacosStartUp {
    private static final String MODE_PROPERTY_KEY_STAND_MODE = "nacos.mode";
    private static final String MODE_PROPERTY_KEY_FUNCTION_MODE = "nacos.function.mode";
    private static final String LOCAL_IP_PROPERTY_KEY = "nacos.local.ip";
    private static final String NACOS_APPLICATION_CONF = "nacos_application_conf";
    private static final String NACOS_MODE_STAND_ALONE = "stand alone";
    private static final String NACOS_MODE_CLUSTER = "cluster";
    private static final String DEFAULT_FUNCTION_MODE = "All";
    private static final String DATASOURCE_PLATFORM_PROPERTY = "spring.sql.init.platform";
    private static final String DERBY_DATABASE = "derby";
    private static final String DEFAULT_DATASOURCE_PLATFORM = "";
    private static final String DATASOURCE_MODE_EXTERNAL = "external";
    private static final String DATASOURCE_MODE_EMBEDDED = "embedded";
    private static final Map<String, Object> SOURCES = new ConcurrentHashMap<String, Object>();

    public NacosCoreStartUp() {
        super("core");
    }

    @Override
    public String[] makeWorkDir() {
        String[] dirNames = new String[]{"logs", "conf", "data"};
        ArrayList<String> result = new ArrayList<String>(dirNames.length);
        for (String dirName : dirNames) {
            try {
                Path path = Paths.get(EnvUtil.getNacosHome(), dirName);
                DiskUtils.forceMkdir((File)new File(path.toUri()));
                result.add(path.toString());
            }
            catch (Exception e) {
                throw new NacosRuntimeException(ErrorCode.IOMakeDirError.getCode(), (Throwable)e);
            }
        }
        return result.toArray(new String[0]);
    }

    @Override
    public void injectEnvironment(ConfigurableEnvironment environment) {
        EnvUtil.setEnvironment((ConfigurableEnvironment)environment);
    }

    @Override
    public void loadPreProperties(ConfigurableEnvironment environment) {
        try {
            SOURCES.putAll(EnvUtil.loadProperties((Resource)EnvUtil.getApplicationConfFileResource()));
            environment.getPropertySources().addLast((PropertySource)new OriginTrackedMapPropertySource(NACOS_APPLICATION_CONF, SOURCES));
            this.registerWatcher();
        }
        catch (Exception e) {
            throw new NacosRuntimeException(500, (Throwable)e);
        }
    }

    @Override
    public void initSystemProperty() {
        if (EnvUtil.getStandaloneMode()) {
            System.setProperty(MODE_PROPERTY_KEY_STAND_MODE, NACOS_MODE_STAND_ALONE);
        } else {
            System.setProperty(MODE_PROPERTY_KEY_STAND_MODE, NACOS_MODE_CLUSTER);
        }
        if (EnvUtil.getFunctionMode() == null) {
            System.setProperty(MODE_PROPERTY_KEY_FUNCTION_MODE, DEFAULT_FUNCTION_MODE);
        } else if ("config".equals(EnvUtil.getFunctionMode())) {
            System.setProperty(MODE_PROPERTY_KEY_FUNCTION_MODE, "config");
        } else if ("naming".equals(EnvUtil.getFunctionMode())) {
            System.setProperty(MODE_PROPERTY_KEY_FUNCTION_MODE, "naming");
        }
        System.setProperty(LOCAL_IP_PROPERTY_KEY, InetUtils.getSelfIP());
    }

    @Override
    public void logStartingInfo(Logger logger) {
        this.logClusterConf(logger);
        super.logStartingInfo(logger);
    }

    @Override
    public void customEnvironment() {
        EnvUtil.customEnvironment();
    }

    @Override
    public void started() {
        super.started();
        ApplicationUtils.setStarted((boolean)true);
    }

    @Override
    protected String getPhaseNameInStartingInfo() {
        return "Nacos Server";
    }

    @Override
    public void logStarted(Logger logger) {
        long endTimestamp = System.currentTimeMillis();
        long startupCost = endTimestamp - this.getStartTimestamp();
        boolean useExternalStorage = this.judgeStorageMode(EnvUtil.getEnvironment());
        logger.info("Nacos started successfully in {} mode with {} storage in {} ms", new Object[]{System.getProperty(MODE_PROPERTY_KEY_STAND_MODE), useExternalStorage ? DATASOURCE_MODE_EXTERNAL : DATASOURCE_MODE_EMBEDDED, startupCost});
    }

    @Override
    public void failed(Throwable exception, ConfigurableApplicationContext context) {
        super.failed(exception, context);
        ThreadPoolManager.shutdown();
        WatchFileCenter.shutdown();
        NotifyCenter.shutdown();
    }

    private void registerWatcher() throws NacosException {
        WatchFileCenter.registerWatcher((String)EnvUtil.getConfPath(), (FileWatcher)new FileWatcher(){

            public void onChange(FileChangeEvent event) {
                try {
                    Map tmp = EnvUtil.loadProperties((Resource)EnvUtil.getApplicationConfFileResource());
                    SOURCES.putAll(tmp);
                    NotifyCenter.publishEvent((Event)ServerConfigChangeEvent.newEvent());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public boolean interest(String context) {
                return StringUtils.contains((CharSequence)context, (CharSequence)"application.properties");
            }
        });
    }

    private void logClusterConf(Logger logger) {
        if (!EnvUtil.getStandaloneMode()) {
            try {
                List clusterConf = EnvUtil.readClusterConf();
                logger.info("The server IP list of Nacos is {}", (Object)clusterConf);
            }
            catch (IOException e) {
                logger.error("read cluster conf fail", (Throwable)e);
            }
        }
    }

    private boolean judgeStorageMode(ConfigurableEnvironment env) {
        boolean useExternalStorage;
        String platform = this.getDatasourcePlatform(env);
        boolean bl = useExternalStorage = !DEFAULT_DATASOURCE_PLATFORM.equalsIgnoreCase(platform) && !DERBY_DATABASE.equalsIgnoreCase(platform);
        if (!useExternalStorage) {
            boolean embeddedStorage;
            boolean bl2 = embeddedStorage = EnvUtil.getStandaloneMode() || Boolean.getBoolean("embeddedStorage");
            if (!embeddedStorage) {
                useExternalStorage = true;
            }
        }
        return useExternalStorage;
    }

    private String getDatasourcePlatform(ConfigurableEnvironment env) {
        return env.getProperty(DATASOURCE_PLATFORM_PROPERTY, DEFAULT_DATASOURCE_PLATFORM);
    }
}

