/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.listener.startup;

import com.alibaba.nacos.common.executor.ExecutorFactory;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.core.listener.startup.NacosStartUp;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.springframework.context.ConfigurableApplicationContext;

public abstract class AbstractNacosStartUp
implements NacosStartUp {
    private final String phase;
    private volatile ScheduledExecutorService startLoggingScheduledExecutor;
    private volatile boolean starting;
    private volatile long startTimestamp;

    protected AbstractNacosStartUp(String phase) {
        this.phase = phase;
    }

    @Override
    public String startUpPhase() {
        return this.phase;
    }

    @Override
    public void starting() {
        this.starting = true;
        this.startTimestamp = System.currentTimeMillis();
        this.startLoggingScheduledExecutor = ExecutorFactory.newSingleScheduledExecutorService((ThreadFactory)new NameThreadFactory(String.format("com.alibaba.nacos.%s.nacos-starting", this.phase)));
    }

    @Override
    public void logStartingInfo(Logger logger) {
        this.startLoggingScheduledExecutor.scheduleWithFixedDelay(() -> {
            if (this.starting) {
                logger.info(String.format("%s is starting...", this.getPhaseNameInStartingInfo()));
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void started() {
        this.starting = false;
        this.closeExecutor();
    }

    @Override
    public void failed(Throwable exception, ConfigurableApplicationContext context) {
        this.starting = false;
        this.closeExecutor();
        context.close();
    }

    protected long getStartTimestamp() {
        return this.startTimestamp;
    }

    protected abstract String getPhaseNameInStartingInfo();

    private void closeExecutor() {
        this.startLoggingScheduledExecutor.shutdownNow();
    }
}

