/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.listener;

import com.alibaba.nacos.core.listener.NacosApplicationListener;
import com.alibaba.nacos.core.listener.startup.NacosStartUp;
import com.alibaba.nacos.core.listener.startup.NacosStartUpManager;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class StartingApplicationListener
implements NacosApplicationListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartingApplicationListener.class);

    @Override
    public void starting() {
        NacosStartUpManager.getCurrentStartUp().starting();
    }

    @Override
    public void environmentPrepared(ConfigurableEnvironment environment) {
        NacosStartUp currentStartUp = NacosStartUpManager.getCurrentStartUp();
        currentStartUp.makeWorkDir();
        currentStartUp.injectEnvironment(environment);
        currentStartUp.loadPreProperties(environment);
        currentStartUp.initSystemProperty();
    }

    @Override
    public void contextPrepared(ConfigurableApplicationContext context) {
        NacosStartUpManager.getCurrentStartUp().logStartingInfo(LOGGER);
    }

    @Override
    public void contextLoaded(ConfigurableApplicationContext context) {
        NacosStartUpManager.getCurrentStartUp().customEnvironment();
    }

    @Override
    public void started(ConfigurableApplicationContext context) {
        NacosStartUp currentStartUp = NacosStartUpManager.getCurrentStartUp();
        currentStartUp.started();
        currentStartUp.logStarted(LOGGER);
    }

    @Override
    public void failed(ConfigurableApplicationContext context, Throwable exception) {
        for (NacosStartUp each : NacosStartUpManager.getReverseStartedList()) {
            each.failed(exception, context);
        }
        LOGGER.error("Startup errors : ", exception);
        LOGGER.error("Nacos failed to start, please see {} for more details.", (Object)Paths.get(EnvUtil.getNacosHome(), "logs/nacos.log"));
    }
}

