/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.exception;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import jakarta.servlet.ServletException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpMediaTypeException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Order(value=-1)
@ControllerAdvice(annotations={NacosApi.class})
@ResponseBody
public class NacosApiExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosApiExceptionHandler.class);

    @ExceptionHandler(value={NacosApiException.class})
    public ResponseEntity<Result<String>> handleNacosApiException(NacosApiException e) {
        LOGGER.error("got exception. {} {}", (Object)e.getErrAbstract(), (Object)e.getErrMsg());
        return ResponseEntity.status((int)e.getErrCode()).body((Object)new Result(Integer.valueOf(e.getDetailErrCode()), e.getErrAbstract(), (Object)e.getErrMsg()));
    }

    @ExceptionHandler(value={NacosException.class})
    public ResponseEntity<Result<String>> handleNacosException(NacosException e) {
        LOGGER.error("got exception. {}", (Object)e.getErrMsg());
        return ResponseEntity.status((int)e.getErrCode()).body((Object)Result.failure((ErrorCode)ErrorCode.SERVER_ERROR, (Object)e.getErrMsg()));
    }

    @ExceptionHandler(value={NacosRuntimeException.class})
    public ResponseEntity<Result<String>> handleNacosRuntimeException(NacosRuntimeException e) {
        LOGGER.error("got exception. {} {}", (Object)e.getMessage(), (Object)ExceptionUtil.getAllExceptionMsg((Throwable)e));
        return ResponseEntity.status((int)e.getErrCode()).body((Object)Result.failure((ErrorCode)ErrorCode.SERVER_ERROR, (Object)e.getMessage()));
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public Result<String> handleHttpMessageNotReadableException(HttpMessageNotReadableException e) {
        LOGGER.error("got exception. {} {}", (Object)e.getMessage(), (Object)ExceptionUtil.getAllExceptionMsg((Throwable)e));
        return Result.failure((ErrorCode)ErrorCode.PARAMETER_MISSING, (Object)e.getMessage());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={HttpMessageConversionException.class})
    public Result<String> handleHttpMessageConversionException(HttpMessageConversionException e) {
        LOGGER.error("got exception. {} {}", (Object)e.getMessage(), (Object)ExceptionUtil.getAllExceptionMsg((Throwable)e));
        return Result.failure((ErrorCode)ErrorCode.PARAMETER_VALIDATE_ERROR, (Object)e.getMessage());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={NumberFormatException.class})
    public Result<String> handleNumberFormatException(NumberFormatException e) {
        LOGGER.error("got exception. {} {}", (Object)e.getMessage(), (Object)ExceptionUtil.getAllExceptionMsg((Throwable)e));
        return Result.failure((ErrorCode)ErrorCode.PARAMETER_VALIDATE_ERROR, (Object)e.getMessage());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={IllegalArgumentException.class})
    public Result<String> handleIllegalArgumentException(IllegalArgumentException e) {
        LOGGER.error("got exception. {} {}", (Object)e.getMessage(), (Object)ExceptionUtil.getAllExceptionMsg((Throwable)e));
        return Result.failure((ErrorCode)ErrorCode.PARAMETER_VALIDATE_ERROR, (Object)e.getMessage());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public Result<String> handleMissingServletRequestParameterException(MissingServletRequestParameterException e) {
        LOGGER.error("got exception. {} {}", (Object)e.getMessage(), (Object)ExceptionUtil.getAllExceptionMsg((Throwable)e));
        return Result.failure((ErrorCode)ErrorCode.PARAMETER_MISSING, (Object)e.getMessage());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={HttpMediaTypeException.class})
    public Result<String> handleHttpMediaTypeException(HttpMediaTypeException e) {
        LOGGER.error("got exception. {} {}", (Object)e.getMessage(), (Object)ExceptionUtil.getAllExceptionMsg((Throwable)e));
        return Result.failure((ErrorCode)ErrorCode.MEDIA_TYPE_ERROR, (Object)e.getMessage());
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={AccessException.class})
    public Result<String> handleAccessException(AccessException e) {
        LOGGER.error("got exception. {} {}", (Object)e.getMessage(), (Object)ExceptionUtil.getAllExceptionMsg((Throwable)e));
        return Result.failure((ErrorCode)ErrorCode.ACCESS_DENIED, (Object)e.getErrMsg());
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={DataAccessException.class, ServletException.class, IOException.class})
    public Result<String> handleDataAccessException(Exception e) {
        LOGGER.error("got exception. {} {}", (Object)e.getMessage(), (Object)ExceptionUtil.getAllExceptionMsg((Throwable)e));
        return Result.failure((ErrorCode)ErrorCode.DATA_ACCESS_ERROR, (Object)e.getMessage());
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    public Result<String> handleOtherException(Exception e) {
        LOGGER.error("got exception. {} {}", (Object)e.getMessage(), (Object)ExceptionUtil.getAllExceptionMsg((Throwable)e));
        return Result.failure((String)e.getMessage());
    }
}

