/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed;

import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.consistency.Config;
import com.alibaba.nacos.consistency.ap.APProtocol;
import com.alibaba.nacos.consistency.cp.CPProtocol;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.MemberChangeListener;
import com.alibaba.nacos.core.cluster.MemberUtil;
import com.alibaba.nacos.core.cluster.MembersChangeEvent;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.distributed.ProtocolExecutor;
import com.alibaba.nacos.core.utils.ClassUtils;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Component;

@Component(value="ProtocolManager")
public class ProtocolManager
extends MemberChangeListener
implements DisposableBean {
    private CPProtocol cpProtocol;
    private APProtocol apProtocol;
    private final ServerMemberManager memberManager;
    private volatile boolean apInit = false;
    private volatile boolean cpInit = false;
    private final Object cpLock = new Object();
    private final Object apLock = new Object();
    private Set<Member> oldMembers;

    public ProtocolManager(ServerMemberManager memberManager) {
        this.memberManager = memberManager;
        NotifyCenter.registerSubscriber((Subscriber)this);
    }

    public static Set<String> toAPMembersInfo(Collection<Member> members) {
        HashSet<String> nodes = new HashSet<String>();
        members.forEach(member -> nodes.add(member.getAddress()));
        return nodes;
    }

    public static Set<String> toCPMembersInfo(Collection<Member> members) {
        HashSet<String> nodes = new HashSet<String>();
        members.forEach(member -> {
            String ip = member.getIp();
            int raftPort = MemberUtil.calculateRaftPort(member);
            nodes.add(ip + ":" + raftPort);
        });
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CPProtocol getCpProtocol() {
        if (!this.cpInit) {
            Object object = this.cpLock;
            synchronized (object) {
                if (!this.cpInit) {
                    this.initCPProtocol();
                    this.cpInit = true;
                }
            }
        }
        return this.cpProtocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APProtocol getApProtocol() {
        if (!this.apInit) {
            Object object = this.apLock;
            synchronized (object) {
                if (!this.apInit) {
                    this.initAPProtocol();
                    this.apInit = true;
                }
            }
        }
        return this.apProtocol;
    }

    public boolean isCpInit() {
        return this.cpInit;
    }

    public boolean isApInit() {
        return this.apInit;
    }

    @PreDestroy
    public void destroy() {
        if (Objects.nonNull(this.apProtocol)) {
            this.apProtocol.shutdown();
        }
        if (Objects.nonNull(this.cpProtocol)) {
            this.cpProtocol.shutdown();
        }
    }

    private void initAPProtocol() {
        ApplicationUtils.getBeanIfExist(APProtocol.class, protocol -> {
            Class configType = ClassUtils.resolveGenericType(protocol.getClass());
            Config config = (Config)ApplicationUtils.getBean(configType);
            this.injectMembers4AP(config);
            protocol.init(config);
            this.apProtocol = protocol;
        });
    }

    private void initCPProtocol() {
        ApplicationUtils.getBeanIfExist(CPProtocol.class, protocol -> {
            Class configType = ClassUtils.resolveGenericType(protocol.getClass());
            Config config = (Config)ApplicationUtils.getBean(configType);
            this.injectMembers4CP(config);
            protocol.init(config);
            this.cpProtocol = protocol;
        });
    }

    private void injectMembers4CP(Config config) {
        Member selfMember = this.memberManager.getSelf();
        String self = selfMember.getIp() + ":" + Integer.parseInt(String.valueOf(selfMember.getExtendVal("raftPort")));
        Set<String> others = ProtocolManager.toCPMembersInfo(this.memberManager.allMembers());
        config.setMembers(self, others);
    }

    private void injectMembers4AP(Config config) {
        String self = this.memberManager.getSelf().getAddress();
        Set<String> others = ProtocolManager.toAPMembersInfo(this.memberManager.allMembers());
        config.setMembers(self, others);
    }

    public void onEvent(MembersChangeEvent event) {
        if (Objects.nonNull(this.apProtocol)) {
            ProtocolExecutor.apMemberChange(() -> this.apProtocol.memberChange(ProtocolManager.toAPMembersInfo(event.getMembers())));
        }
        if (Objects.nonNull(this.cpProtocol)) {
            ProtocolExecutor.cpMemberChange(() -> this.cpProtocol.memberChange(ProtocolManager.toCPMembersInfo(event.getMembers())));
        }
    }
}

