/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.controller.v3;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.core.cluster.health.ModuleHealthCheckerHolder;
import com.alibaba.nacos.core.cluster.health.ReadinessResult;
import com.alibaba.nacos.core.service.NacosServerStateService;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v3/admin/core/state"})
public class ServerStateController {
    private final NacosServerStateService stateService;

    public ServerStateController(NacosServerStateService stateService) {
        this.stateService = stateService;
    }

    @GetMapping
    public Result<Map<String, String>> serverState() {
        return Result.success(this.stateService.getServerState());
    }

    @GetMapping(value={"/liveness"})
    public Result<String> liveness() {
        return Result.success((Object)"ok");
    }

    @GetMapping(value={"/readiness"})
    public Result<String> readiness() throws NacosException {
        ReadinessResult result = ModuleHealthCheckerHolder.getInstance().checkReadiness();
        if (result.isSuccess()) {
            return Result.success((Object)"ok");
        }
        return Result.failure((String)result.getResultMessage());
    }
}

