/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.controller.v3;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.model.response.ServerLoaderMetrics;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.core.remote.Connection;
import com.alibaba.nacos.core.service.NacosServerLoaderService;
import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v3/admin/core/loader"})
public class ServerLoaderControllerV3 {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerLoaderControllerV3.class);
    private final NacosServerLoaderService serverLoaderService;

    public ServerLoaderControllerV3(NacosServerLoaderService serverLoaderService) {
        this.serverLoaderService = serverLoaderService;
    }

    @GetMapping(value={"/current"})
    @Secured(resource="/v3/admin/core/loader", action=ActionTypes.READ, apiType=ApiType.ADMIN_API)
    public Result<Map<String, Connection>> currentClients() {
        return Result.success(this.serverLoaderService.getAllClients());
    }

    @Secured(resource="/v3/admin/core/loader", action=ActionTypes.WRITE, apiType=ApiType.ADMIN_API)
    @PostMapping(value={"/reloadCurrent"})
    public Result<String> reloadCount(@RequestParam Integer count, @RequestParam(value="redirectAddress", required=false) String redirectAddress) {
        this.serverLoaderService.reloadCount(count, redirectAddress);
        return Result.success();
    }

    @PostMapping(value={"/smartReloadCluster"})
    @Secured(resource="/v3/admin/core/loader", action=ActionTypes.WRITE, apiType=ApiType.ADMIN_API)
    public Result<String> smartReload(HttpServletRequest request, @RequestParam(value="loaderFactor", defaultValue="0.1f") String loaderFactorStr) {
        LOGGER.info("Smart reload request receive,requestIp={}", (Object)WebUtils.getRemoteIp(request));
        float loaderFactor = Float.parseFloat(loaderFactorStr);
        if (!this.serverLoaderService.smartReload(loaderFactor)) {
            return Result.failure((ErrorCode)ErrorCode.SERVER_ERROR, (Object)"Smart reload failed, please try again later.");
        }
        return Result.success();
    }

    @PostMapping(value={"/reloadClient"})
    @Secured(resource="/v3/admin/core/loader", action=ActionTypes.WRITE, apiType=ApiType.ADMIN_API)
    public Result<String> reloadSingle(@RequestParam String connectionId, @RequestParam(value="redirectAddress", required=false) String redirectAddress) {
        this.serverLoaderService.reloadClient(connectionId, redirectAddress);
        return Result.success();
    }

    @GetMapping(value={"/cluster"})
    @Secured(resource="/v3/admin/core/loader", action=ActionTypes.READ, apiType=ApiType.ADMIN_API)
    public Result<ServerLoaderMetrics> loaderMetrics() {
        return Result.success((Object)this.serverLoaderService.getServerLoaderMetrics());
    }
}

