/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.controller.v3;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.response.Namespace;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.namespace.model.form.NamespaceForm;
import com.alibaba.nacos.core.namespace.repository.NamespacePersistService;
import com.alibaba.nacos.core.service.NamespaceOperationService;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v3/admin/core/namespace"})
public class NamespaceControllerV3 {
    private final NamespaceOperationService namespaceOperationService;
    private final NamespacePersistService namespacePersistService;
    private final Pattern namespaceIdCheckPattern = Pattern.compile("^[\\w-]+");
    private final Pattern namespaceNameCheckPattern = Pattern.compile("^[^@#$%^&*]+$");
    private static final int NAMESPACE_ID_MAX_LENGTH = 128;

    public NamespaceControllerV3(NamespaceOperationService namespaceOperationService, NamespacePersistService namespacePersistService) {
        this.namespaceOperationService = namespaceOperationService;
        this.namespacePersistService = namespacePersistService;
    }

    @GetMapping(value={"/list"})
    @Secured(resource="/v3/admin/core/namespace", action=ActionTypes.READ, signType="console", apiType=ApiType.ADMIN_API)
    public Result<List<Namespace>> getNamespaceList() {
        return Result.success(this.namespaceOperationService.getNamespaceList());
    }

    @GetMapping
    @Secured(resource="/v3/admin/corenamespaces", action=ActionTypes.READ, signType="console", apiType=ApiType.ADMIN_API)
    public Result<Namespace> getNamespace(@RequestParam(value="namespaceId") String namespaceId) throws NacosException {
        return Result.success((Object)this.namespaceOperationService.getNamespace(namespaceId));
    }

    @PostMapping
    @Secured(resource="/v3/admin/corenamespaces", action=ActionTypes.WRITE, signType="console", apiType=ApiType.ADMIN_API)
    public Result<Boolean> createNamespace(NamespaceForm namespaceForm) throws Exception {
        namespaceForm.validate();
        String namespaceId = namespaceForm.getNamespaceId();
        String namespaceName = namespaceForm.getNamespaceName();
        String namespaceDesc = namespaceForm.getNamespaceDesc();
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = UUID.randomUUID().toString();
        } else {
            if (!this.namespaceIdCheckPattern.matcher(namespaceId = namespaceId.trim()).matches()) {
                throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.ILLEGAL_NAMESPACE, "namespaceId [" + namespaceId + "] mismatch the pattern");
            }
            if (namespaceId.length() > 128) {
                throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.ILLEGAL_NAMESPACE, "too long namespaceId, over 128");
            }
        }
        if (!this.namespaceNameCheckPattern.matcher(namespaceName).matches()) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.ILLEGAL_NAMESPACE, "namespaceName [" + namespaceName + "] contains illegal char");
        }
        return Result.success((Object)this.namespaceOperationService.createNamespace(namespaceId, namespaceName, namespaceDesc));
    }

    @PutMapping
    @Secured(resource="/v3/admin/corenamespaces", action=ActionTypes.WRITE, signType="console", apiType=ApiType.ADMIN_API)
    public Result<Boolean> updateNamespace(NamespaceForm namespaceForm) throws NacosException {
        namespaceForm.validate();
        if (!this.namespaceNameCheckPattern.matcher(namespaceForm.getNamespaceName()).matches()) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.ILLEGAL_NAMESPACE, "namespaceName [" + namespaceForm.getNamespaceName() + "] contains illegal char");
        }
        return Result.success((Object)this.namespaceOperationService.editNamespace(namespaceForm.getNamespaceId(), namespaceForm.getNamespaceName(), namespaceForm.getNamespaceDesc()));
    }

    @DeleteMapping
    @Secured(resource="/v3/admin/corenamespaces", action=ActionTypes.WRITE, signType="console", apiType=ApiType.ADMIN_API)
    public Result<Boolean> deleteNamespace(@RequestParam(value="namespaceId") String namespaceId) {
        return Result.success((Object)this.namespaceOperationService.removeNamespace(namespaceId));
    }

    @GetMapping(value={"/check"})
    @Secured(resource="/v3/admin/corenamespaces", action=ActionTypes.READ, signType="console", apiType=ApiType.ADMIN_API)
    public Result<Integer> checkNamespaceIdExist(@RequestParam(value="namespaceId") String namespaceId) {
        return Result.success((Object)this.namespacePersistService.tenantInfoCountByTenantId(namespaceId));
    }
}

