/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.controller.v3;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.model.response.IdGeneratorInfo;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.core.distributed.ProtocolManager;
import com.alibaba.nacos.core.distributed.id.IdGeneratorManager;
import com.alibaba.nacos.core.model.form.v3.RaftCommandForm;
import com.alibaba.nacos.core.model.request.LogUpdateRequest;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v3/admin/core/ops"})
public class CoreOpsControllerV3 {
    private final ProtocolManager protocolManager;
    private final IdGeneratorManager idGeneratorManager;

    public CoreOpsControllerV3(ProtocolManager protocolManager, IdGeneratorManager idGeneratorManager) {
        this.protocolManager = protocolManager;
        this.idGeneratorManager = idGeneratorManager;
    }

    @PostMapping(value={"/raft"})
    @Secured(resource="/v3/admin/core/ops", action=ActionTypes.WRITE, signType="console", apiType=ApiType.ADMIN_API)
    public Result<String> raftOps(@RequestBody RaftCommandForm form) {
        return Result.success((Object)((String)this.protocolManager.getCpProtocol().execute(form.toMap()).getData()));
    }

    @GetMapping(value={"/ids"})
    @Secured(resource="/v3/admin/core/ops", action=ActionTypes.WRITE, signType="console", apiType=ApiType.ADMIN_API)
    public Result<List<IdGeneratorInfo>> ids() {
        ArrayList result = new ArrayList();
        this.idGeneratorManager.getGeneratorMap().forEach((resource, idGenerator) -> {
            IdGeneratorInfo vo = new IdGeneratorInfo();
            vo.setResource(resource);
            IdGeneratorInfo.IdInfo info = new IdGeneratorInfo.IdInfo();
            info.setCurrentId(Long.valueOf(idGenerator.currentId()));
            info.setWorkerId(Long.valueOf(idGenerator.workerId()));
            vo.setInfo(info);
            result.add(vo);
        });
        return Result.success(result);
    }

    @PutMapping(value={"/log"})
    @Secured(resource="/v3/admin/core/ops", action=ActionTypes.WRITE, signType="console", apiType=ApiType.ADMIN_API)
    public Result<Void> updateLog(@RequestBody LogUpdateRequest logUpdateRequest) {
        Loggers.setLogLevel(logUpdateRequest.getLogName(), logUpdateRequest.getLogLevel());
        return Result.success();
    }
}

