/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.controller.v2;

import com.alibaba.nacos.api.model.response.IdGeneratorInfo;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.core.controller.compatibility.Compatibility;
import com.alibaba.nacos.core.distributed.ProtocolManager;
import com.alibaba.nacos.core.distributed.id.IdGeneratorManager;
import com.alibaba.nacos.core.model.request.LogUpdateRequest;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/core/ops"})
@Deprecated
public class CoreOpsV2Controller {
    private final ProtocolManager protocolManager;
    private final IdGeneratorManager idGeneratorManager;

    public CoreOpsV2Controller(ProtocolManager protocolManager, IdGeneratorManager idGeneratorManager) {
        this.protocolManager = protocolManager;
        this.idGeneratorManager = idGeneratorManager;
    }

    @PostMapping(value={"/raft"})
    @Secured(action=ActionTypes.WRITE, resource="nacos/admin", signType="console")
    @Compatibility(apiType=ApiType.ADMIN_API, alternatives="POST {contextPath:nacos}/v3/admin/core/ops/raft")
    public RestResult<String> raftOps(@RequestBody Map<String, String> commands) {
        return this.protocolManager.getCpProtocol().execute(commands);
    }

    @GetMapping(value={"/ids"})
    @Compatibility(apiType=ApiType.ADMIN_API, alternatives="GET {contextPath:nacos}/v3/admin/core/ops/ids")
    public RestResult<List<IdGeneratorInfo>> ids() {
        ArrayList result = new ArrayList();
        this.idGeneratorManager.getGeneratorMap().forEach((resource, idGenerator) -> {
            IdGeneratorInfo vo = new IdGeneratorInfo();
            vo.setResource(resource);
            IdGeneratorInfo.IdInfo info = new IdGeneratorInfo.IdInfo();
            info.setCurrentId(Long.valueOf(idGenerator.currentId()));
            info.setWorkerId(Long.valueOf(idGenerator.workerId()));
            vo.setInfo(info);
            result.add(vo);
        });
        return RestResultUtils.success(result);
    }

    @PutMapping(value={"/log"})
    @Secured(action=ActionTypes.WRITE, resource="nacos/admin", signType="console")
    @Compatibility(apiType=ApiType.ADMIN_API, alternatives="PUT {contextPath:nacos}/v3/admin/core/ops/log")
    public RestResult<Void> updateLog(@RequestBody LogUpdateRequest logUpdateRequest) {
        Loggers.setLogLevel(logUpdateRequest.getLogName(), logUpdateRequest.getLogLevel());
        return RestResultUtils.success();
    }
}

