/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.controller.compatibility;

import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.auth.InnerApiAuthEnabled;
import com.alibaba.nacos.core.code.ControllerMethodsCache;
import com.alibaba.nacos.core.controller.compatibility.ApiCompatibilityConfig;
import com.alibaba.nacos.core.controller.compatibility.Compatibility;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Method;

public class ApiCompatibilityFilter
implements Filter {
    private static final String MESSAGE_NO_REPLACED_API = "Current API will be deprecated, If wanted continue to use, please set `%s=true` in application.properties.";
    private static final String MESSAGE_REPLACED_API = "Current API will be deprecated, please use API(s) `%s` instead, or set `%s=true` in application.properties.";
    private final ControllerMethodsCache methodsCache;
    private final InnerApiAuthEnabled innerApiAuthEnabled;

    public ApiCompatibilityFilter(ControllerMethodsCache methodsCache, InnerApiAuthEnabled innerApiAuthEnabled) {
        this.methodsCache = methodsCache;
        this.innerApiAuthEnabled = innerApiAuthEnabled;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        try {
            Method method = this.methodsCache.getMethod(request);
            if (method == null) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            Compatibility compatibility = method.getAnnotation(Compatibility.class);
            if (null == compatibility) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            ApiType apiType = compatibility.apiType();
            switch (apiType) {
                case ADMIN_API: {
                    if (ApiCompatibilityConfig.getInstance().isAdminApiCompatibility()) break;
                    this.responseReject(response, compatibility, "nacos.core.api.compatibility.admin.enabled");
                    return;
                }
                case OPEN_API: {
                    if (ApiCompatibilityConfig.getInstance().isClientApiCompatibility()) break;
                    this.responseReject(response, compatibility, "nacos.core.api.compatibility.client.enabled");
                    return;
                }
                case CONSOLE_API: {
                    if (ApiCompatibilityConfig.getInstance().isConsoleApiCompatibility()) break;
                    this.responseReject(response, compatibility, "nacos.core.api.compatibility.console.enabled");
                    return;
                }
                case INNER_API: {
                    if (!this.innerApiAuthEnabled.isEnabled()) break;
                    Result result = Result.failure((Integer)ErrorCode.API_DEPRECATED.getCode(), (String)String.format("Old Inner API %s is deprecated", request.getRequestURI()), null);
                    response.sendError(410, JacksonUtils.toJson((Object)result));
                    return;
                }
                default: {
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
        catch (Exception e) {
            Loggers.CORE.error("Filter for API {} Compatibility failed.", (Object)request.getRequestURI(), (Object)e);
            response.sendError(500, "Handle API Compatibility failed, please see log for detail.");
        }
    }

    private void responseReject(HttpServletResponse response, Compatibility compatibility, String switchName) throws IOException {
        String replacedApis = compatibility.alternatives();
        String message = StringUtils.isBlank((CharSequence)replacedApis) ? String.format(MESSAGE_NO_REPLACED_API, switchName) : String.format(MESSAGE_REPLACED_API, replacedApis, switchName);
        Result result = Result.failure((Integer)ErrorCode.API_DEPRECATED.getCode(), (String)message, null);
        response.sendError(410, JacksonUtils.toJson((Object)result));
    }
}

