/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.controller.compatibility;

import com.alibaba.nacos.core.config.AbstractDynamicConfig;
import com.alibaba.nacos.sys.env.EnvUtil;

public class ApiCompatibilityConfig
extends AbstractDynamicConfig {
    private static final String API_COMPATIBILITY = "ApiCompatibility";
    private static final ApiCompatibilityConfig INSTANCE = new ApiCompatibilityConfig();
    private static final String PREFIX = "nacos.core.api.compatibility";
    public static final String CLIENT_API_COMPATIBILITY_KEY = "nacos.core.api.compatibility.client.enabled";
    public static final String CONSOLE_API_COMPATIBILITY_KEY = "nacos.core.api.compatibility.console.enabled";
    public static final String ADMIN_API_COMPATIBILITY_KEY = "nacos.core.api.compatibility.admin.enabled";
    private boolean clientApiCompatibility;
    private boolean consoleApiCompatibility;
    private boolean adminApiCompatibility;

    protected ApiCompatibilityConfig() {
        super(API_COMPATIBILITY);
        this.resetConfig();
    }

    public static ApiCompatibilityConfig getInstance() {
        return INSTANCE;
    }

    @Override
    protected void getConfigFromEnv() {
        this.clientApiCompatibility = (Boolean)EnvUtil.getProperty((String)CLIENT_API_COMPATIBILITY_KEY, Boolean.class, (Object)true);
        this.consoleApiCompatibility = (Boolean)EnvUtil.getProperty((String)CONSOLE_API_COMPATIBILITY_KEY, Boolean.class, (Object)false);
        this.adminApiCompatibility = (Boolean)EnvUtil.getProperty((String)ADMIN_API_COMPATIBILITY_KEY, Boolean.class, (Object)false);
    }

    @Override
    protected String printConfig() {
        return this.toString();
    }

    public String toString() {
        return "ApiCompatibilityConfig{clientApiCompatibility=" + this.clientApiCompatibility + ", consoleApiCompatibility=" + this.consoleApiCompatibility + ", adminApiCompatibility=" + this.adminApiCompatibility + "}";
    }

    public boolean isClientApiCompatibility() {
        return this.clientApiCompatibility;
    }

    public void setClientApiCompatibility(boolean clientApiCompatibility) {
        this.clientApiCompatibility = clientApiCompatibility;
    }

    public boolean isConsoleApiCompatibility() {
        return this.consoleApiCompatibility;
    }

    public void setConsoleApiCompatibility(boolean consoleApiCompatibility) {
        this.consoleApiCompatibility = consoleApiCompatibility;
    }

    public boolean isAdminApiCompatibility() {
        return this.adminApiCompatibility;
    }

    public void setAdminApiCompatibility(boolean adminApiCompatibility) {
        this.adminApiCompatibility = adminApiCompatibility;
    }
}

