/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.controller;

import com.alibaba.nacos.api.common.NodeState;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.LoggerUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.controller.compatibility.Compatibility;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/core/cluster"})
@Deprecated
public class NacosClusterController {
    private final ServerMemberManager memberManager;

    public NacosClusterController(ServerMemberManager memberManager) {
        this.memberManager = memberManager;
    }

    @GetMapping(value={"/self"})
    @Secured(resource="/v1/core/cluster", action=ActionTypes.READ, signType="console")
    @Compatibility(apiType=ApiType.ADMIN_API, alternatives="GET {contextPath:nacos}/v3/admin/core/cluster/node/self")
    public RestResult<Member> self() {
        return RestResultUtils.success((Object)this.memberManager.getSelf());
    }

    @GetMapping(value={"/nodes"})
    @Secured(resource="/v1/core/cluster", action=ActionTypes.READ, signType="console")
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/admin/core/cluster/node/list")
    public RestResult<Collection<Member>> listNodes(@RequestParam(value="keyword", required=false) String ipKeyWord) {
        Collection<Member> members = this.memberManager.allMembers();
        ArrayList result = new ArrayList();
        members.stream().sorted().forEach(member -> {
            if (StringUtils.isBlank((CharSequence)ipKeyWord)) {
                result.add(member);
                return;
            }
            String address = member.getAddress();
            if (StringUtils.equals((String)address, (String)ipKeyWord) || StringUtils.startsWith((CharSequence)address, (CharSequence)ipKeyWord)) {
                result.add(member);
            }
        });
        return RestResultUtils.success(result);
    }

    @GetMapping(value={"/simple/nodes"})
    @Secured(resource="/v1/core/cluster", action=ActionTypes.READ, signType="console")
    @Compatibility(apiType=ApiType.ADMIN_API)
    public RestResult<Collection<String>> listSimpleNodes() {
        return RestResultUtils.success(this.memberManager.getMemberAddressInfos());
    }

    @GetMapping(value={"/health"})
    @Secured(resource="/v1/core/cluster", action=ActionTypes.READ, signType="console")
    @Compatibility(apiType=ApiType.ADMIN_API, alternatives="GET {contextPath:nacos}/v3/admin/core/cluster/node/self/health")
    public RestResult<String> getHealth() {
        return RestResultUtils.success((Object)this.memberManager.getSelf().getState().name());
    }

    @Deprecated
    @PostMapping(value={"/report"})
    @Secured(resource="/v1/core/cluster", action=ActionTypes.WRITE, signType="console", apiType=ApiType.INNER_API)
    @Compatibility(apiType=ApiType.INNER_API)
    public RestResult<String> report(@RequestBody Member node) {
        if (!node.check()) {
            return RestResultUtils.failedWithMsg((int)400, (String)"Node information is illegal");
        }
        LoggerUtils.printIfDebugEnabled((Logger)Loggers.CLUSTER, (String)"node state report, receive info : {}", (Object[])new Object[]{node});
        node.setState(NodeState.UP);
        node.setFailAccessCnt(0);
        this.memberManager.update(node);
        return RestResultUtils.success((Object)JacksonUtils.toJson((Object)this.memberManager.getSelf()));
    }

    @PostMapping(value={"/switch/lookup"})
    @Secured(resource="/v1/core/cluster", action=ActionTypes.WRITE, signType="console")
    @Compatibility(apiType=ApiType.ADMIN_API, alternatives="PUT {contextPath:nacos}/v3/admin/core/cluster/lookup")
    public RestResult<String> switchLookup(@RequestParam(name="type") String type) {
        try {
            this.memberManager.switchLookup(type);
            return RestResultUtils.success();
        }
        catch (Throwable ex) {
            return RestResultUtils.failed((String)ex.getMessage());
        }
    }

    @PostMapping(value={"/server/leave"})
    @Secured(resource="/v1/core/cluster", action=ActionTypes.WRITE, signType="console")
    @Compatibility(apiType=ApiType.CONSOLE_API)
    public RestResult<String> leave(@RequestBody Collection<String> params, @RequestParam(defaultValue="true") Boolean notifyOtherMembers) throws Exception {
        return RestResultUtils.failed((int)405, null, (String)"/v1/core/cluster/server/leave API not allow to use temporarily.");
    }
}

