/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.control.http;

import com.alibaba.nacos.api.remote.RpcScheduledExecutor;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.code.ControllerMethodsCache;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.control.TpsControlConfig;
import com.alibaba.nacos.core.control.http.HttpTpsCheckRequestParser;
import com.alibaba.nacos.core.control.http.HttpTpsCheckRequestParserRegistry;
import com.alibaba.nacos.plugin.control.ControlManagerCenter;
import com.alibaba.nacos.plugin.control.Loggers;
import com.alibaba.nacos.plugin.control.tps.TpsControlManager;
import com.alibaba.nacos.plugin.control.tps.request.TpsCheckRequest;
import com.alibaba.nacos.plugin.control.tps.response.TpsCheckResponse;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

public class NacosHttpTpsFilter
implements Filter {
    private ControllerMethodsCache controllerMethodsCache;
    private TpsControlManager tpsControlManager;

    public NacosHttpTpsFilter(ControllerMethodsCache controllerMethodsCache) {
        this.controllerMethodsCache = controllerMethodsCache;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    private void initTpsControlManager() {
        if (this.tpsControlManager == null) {
            this.tpsControlManager = ControlManagerCenter.getInstance().getTpsControlManager();
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        Method method = this.controllerMethodsCache.getMethod(httpServletRequest);
        try {
            if (method != null && method.isAnnotationPresent(TpsControl.class) && TpsControlConfig.isTpsControlEnabled()) {
                TpsControl tpsControl = method.getAnnotation(TpsControl.class);
                String pointName = tpsControl.pointName();
                String parserName = StringUtils.isBlank((CharSequence)tpsControl.name()) ? pointName : tpsControl.name();
                HttpTpsCheckRequestParser parser = HttpTpsCheckRequestParserRegistry.getParser(parserName);
                TpsCheckRequest httpTpsCheckRequest = null;
                if (parser != null) {
                    httpTpsCheckRequest = parser.parse(httpServletRequest);
                }
                if (httpTpsCheckRequest == null) {
                    httpTpsCheckRequest = new TpsCheckRequest();
                }
                if (StringUtils.isBlank((CharSequence)httpTpsCheckRequest.getPointName())) {
                    httpTpsCheckRequest.setPointName(pointName);
                }
                this.initTpsControlManager();
                TpsCheckResponse checkResponse = this.tpsControlManager.check(httpTpsCheckRequest);
                if (!checkResponse.isSuccess()) {
                    AsyncContext asyncContext = httpServletRequest.startAsync();
                    asyncContext.setTimeout(0L);
                    RpcScheduledExecutor.CONTROL_SCHEDULER.schedule(() -> this.generate503Response(httpServletRequest, response, checkResponse.getMessage(), asyncContext), 1000L, TimeUnit.MILLISECONDS);
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            Loggers.TPS.warn("Fail to  http tps check", throwable);
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)response);
    }

    public void destroy() {
        super.destroy();
    }

    void generate503Response(HttpServletRequest request, HttpServletResponse response, String message, AsyncContext asyncContext) {
        try {
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
            response.setHeader("Cache-Control", "no-cache,no-store");
            response.setStatus(503);
            response.getOutputStream().println(message);
            asyncContext.complete();
        }
        catch (Exception ex) {
            Loggers.TPS.error("Error to generate tps 503 response", (Throwable)ex);
        }
    }
}

